/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestClaimFileWriter
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TestClaimFileWriter.class);
    private final String filePath;
    private long count;
    private Writer writer;

    private TestClaimFileWriter() {
        this(null);
    }

    public TestClaimFileWriter(String filePath) {
        this.filePath = filePath;
        this.count = 0L;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final long getCurrentClaimCount() {
        return this.count;
    }

    public final boolean open() throws IOException {
        if (this.writer == null) {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filePath), StandardCharsets.UTF_8);
        } else {
            logger.warn("Open method called on an already-opened writer for file \"{}\".", (Object)this.filePath);
        }
        return true;
    }

    @Override
    public final void close() throws IOException {
        if (this.writer == null) {
            logger.warn("Close method called on an already-closed writer for file \"{}\".", (Object)this.filePath);
        } else {
            this.writer.close();
            this.writer = null;
        }
    }

    public final void write(ClaimModel claim) throws IOException {
        for (RecordModel recordModel : claim.getRecords()) {
            if (recordModel == null) {
                logger.warn("No record to write.");
                continue;
            }
            if (recordModel.getData() == null) {
                logger.warn("No record data to write.");
                continue;
            }
            this.writer.write(recordModel.getData());
            this.writer.write("\r\n");
        }
        this.writer.flush();
        ++this.count;
    }
}

