package gov.cms.oce;

import com.mmm.his.cer.foundation.transfer.IClaim;
import gov.cms.oce.model.external.OceClaim;
import java.util.Objects;

/**
 * Wraps an {@link OceClaim} to unify the API.
 * 
 * @author CMS
 * @version 1.0, 09/01/2022
 */
public class IoceClaim implements IClaim {

  private static final long serialVersionUID = -4854348864831955022L;
  private final OceClaim oceClaim;

  /**
   * Ctor.
   */
  public IoceClaim(OceClaim claim) {
    super();
    Objects.requireNonNull(claim, "Claim object is required.");
    this.oceClaim = claim;
  }

  public OceClaim getModel() {
    return this.oceClaim;
  }

  @Override
  public void setClaimId(String claimId) {
    this.oceClaim.getProcessingInformation().setClaimId(claimId);
  }

  @Override
  public String getClaimId() {
    return this.oceClaim.getProcessingInformation().getClaimId();
  }

}
