/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import gov.cms.oce.Ioce;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoceMain {
    private static final Logger logger = LoggerFactory.getLogger(IoceMain.class);
    @Parameter(names={"--help", "-h"}, help=true)
    private boolean help;
    @Parameter(names={"-input"}, description="Location of input files ", required=true)
    private String inputFile;
    @Parameter(names={"-output"}, description="name of output file", required=true)
    private String outputFile;
    private Charset charSet = null;

    public static void main(String[] args) {
        IoceMain ioceMain = new IoceMain();
        JCommander commander = new JCommander(ioceMain);
        commander.parse(args);
        if (ioceMain.help) {
            commander.usage();
            return;
        }
        long start = 0L;
        start = System.currentTimeMillis();
        logger.info("Default encoding is : {}", (Object)Charset.defaultCharset());
        List<String> records = null;
        try {
            records = IoceMain.populateClaimsFromTextFile(ioceMain.inputFile, ioceMain.charSet);
        }
        catch (IOException exc1) {
            logger.error("Failed to read input file " + ioceMain.inputFile, exc1);
            return;
        }
        ArrayList<String> groupingResults = new ArrayList<String>();
        int count = 1;
        for (String item : records) {
            try {
                String actualResult = Ioce.processIoce(item);
                groupingResults.add(actualResult);
            }
            catch (Exception exc) {
                logger.error("Failed to process claim #{}", (Object)count, (Object)exc);
            }
            ++count;
        }
        ioceMain.writeClaimsToFile(ioceMain.outputFile, groupingResults);
        long end = System.currentTimeMillis();
        String time = String.format("%.3fs", (double)(end - start) / 1000.0);
        logger.info("Processed {} claim(s) in {}", (Object)records.size(), (Object)time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> populateClaimsFromTextFile(String fileName, Charset charSet) throws IOException {
        ArrayList<String> claims = new ArrayList<String>();
        File theFile = new File(fileName);
        logger.info("Reading file from " + theFile.getAbsolutePath());
        FileInputStream is = null;
        InputStreamReader isr = null;
        BufferedReader lrdr = null;
        try {
            is = new FileInputStream(theFile);
            if (charSet != null) {
                logger.info("Reading file using charset {}", (Object)charSet.name());
                isr = new InputStreamReader((InputStream)is, charSet);
            } else {
                isr = new InputStreamReader(is);
            }
            lrdr = new BufferedReader(isr);
            String line = null;
            while ((line = lrdr.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                claims.add(line);
            }
            lrdr.close();
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (isr != null) {
                isr.close();
            }
            if (lrdr != null) {
                lrdr.close();
            }
        }
        return claims;
    }

    public void writeClaimsToFile(String fileName, List<String> outputData) {
        File outFile = new File(fileName);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(outFile));){
            for (String item : outputData) {
                bw.write(item);
                bw.write("\r\n");
            }
        }
        catch (Exception exc) {
            logger.error("Error opening output file", exc);
        }
    }
}

