/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.mainframe.utility.MainframeWrapperException;
import gov.agency.mainframe.utility.impl.WrappedComponent;
import gov.agency.mainframe.utility.util.MainframeProperties;
import gov.agency.mainframe.utility.util.StringUtilities;
import gov.cms.oce.IoceClaim;
import gov.cms.oce.IoceComponent;
import gov.cms.oce.IoceRuntimeOption;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.util.converter.OceClaimToStringClaimConverter;
import gov.cms.oce.util.converter.StringClaimToOceClaimConverter;

public final class IoceMainframeWrapper
implements WrappedComponent {
    public static final int UNKNOWN_ERROR_RETURN_CODE = 888;
    private static final int OUTPUT_WIDTH = 97820;
    private static final int RETURN_CODE_START_INDEX = 393;
    private static final int RETURN_CODE_WIDTH = 2;
    private final StringClaimToOceClaimConverter inputConverter = new StringClaimToOceClaimConverter();
    private final OceClaimToStringClaimConverter outputConverter = new OceClaimToStringClaimConverter();
    private IoceComponent component = null;

    @Override
    public final void initialize(MainframeProperties properties) throws MainframeWrapperException {
        IoceRuntimeOption runtimeOpts = new IoceRuntimeOption();
        try {
            this.component = new IoceComponent(runtimeOpts);
        }
        catch (Exception exc) {
            throw new MainframeWrapperException("Failed to instantiate " + IoceComponent.class.getName(), exc);
        }
    }

    @Override
    public final String process(String inputString) throws MainframeWrapperException {
        OceClaim claim = this.inputConverter.convert(inputString);
        IoceClaim inputClaim = new IoceClaim(claim);
        try {
            this.component.process(inputClaim);
        }
        catch (FoundationException exc) {
            throw new MainframeWrapperException("Failed to process record '" + inputClaim.getClaimId() + "'", exc);
        }
        return this.outputConverter.convert(inputClaim.getModel());
    }

    @Override
    public final String processException(Exception exc, String inputString) {
        StringBuilder formatted = StringUtilities.newBlankBuilder(97820);
        formatted.replace(393, 395, StringUtilities.padLeft(String.valueOf(888), 2, Character.valueOf(' ')));
        return formatted.toString();
    }
}

