/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.api;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.util.FileProcessExecutor;
import gov.cms.oce.util.FileProcessor;
import gov.cms.oce.util.converter.OceClaimDefinition;
import gov.cms.oce.util.converter.OceClaimToTestClaimConverter;
import gov.cms.oce.util.converter.StringClaimToOceClaimConverter;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.TestClaimFileWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainframeToBatchConverterApi
implements FileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MainframeToBatchConverterApi.class);
    private static final MainframeToBatchConverterApi API = new MainframeToBatchConverterApi();

    @Override
    public final void process(String inputFilePath, String outputFilePath) {
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(inputFilePath), StandardCharsets.UTF_8));
             TestClaimFileWriter writer = new TestClaimFileWriter(outputFilePath);){
            String line;
            writer.open();
            StringClaimToOceClaimConverter inputConverter = new StringClaimToOceClaimConverter();
            OceClaimDefinition oceClaimDefinition = new OceClaimDefinition();
            OceClaimToTestClaimConverter outputConverter = new OceClaimToTestClaimConverter(oceClaimDefinition.getClaimDefinition());
            while ((line = reader.readLine()) != null) {
                OceClaim claim = inputConverter.convert(line);
                ClaimModel claimModel = outputConverter.convert(claim);
                writer.write(claimModel);
            }
        }
        catch (IOException e) {
            logger.error("IOException while processing input file \"{}\"", (Object)inputFilePath, (Object)e);
        }
        catch (Exception e) {
            logger.error("Exception while processing input file \"{}\"", (Object)inputFilePath, (Object)e);
        }
    }

    @Override
    public final void process(File inputFile, File outputFile) {
        this.process(inputFile.getAbsolutePath(), outputFile.getAbsolutePath());
    }

    public static final void main(String[] v) throws IOException {
        if (v.length != 2) {
            logger.error("java -jar MainframeApi <path-to-input-file> <path-to-output-file>");
            return;
        }
        FileProcessExecutor fileProcessExecutor = new FileProcessExecutor();
        fileProcessExecutor.processFile(new MainframeToBatchConverterApi(), v[0], v[1]);
    }
}

