/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.api;

import gov.cms.oce.dao.dsc.DescriptionDaoFactory;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.internal.OceClaimProcessor;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimExecutor.class);
    private final ClaimProcessor claimProcessor = new OceClaimProcessor();

    public final synchronized void processClaim(OceClaim oceClaim) {
        if (logger.isDebugEnabled()) {
            logger.debug("Processing Claim \"{}\"", (Object)oceClaim.getProcessingInformation().getClaimId());
        }
        boolean success = !this.claimProcessor.process(oceClaim);
        Integer returnCode = oceClaim.getProcessingInformation().getReturnCode();
        if (returnCode == null) {
            logger.error("Return null return code.");
        } else if (returnCode == 0) {
            if (success) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Zero return code value \"{}\" generated by successfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
                }
            } else {
                logger.error("Zero return code value \"{}\" generated by unsuccessfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
            }
        } else if (success) {
            logger.warn("Non-zero return code value \"{}\" generated by successfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
        } else if (logger.isWarnEnabled()) {
            logger.warn("Non-zero return code value \"{}\" generated by unsuccessfully run claim \"{}\".", (Object)returnCode, (Object)oceClaim.getProcessingInformation().getClaimId());
        }
    }

    public final synchronized String getApcDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getApcDescription(OceLineItem line, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getDescription(line.getPaymentApc(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestApcDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestApcDescription(OceLineItem line) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscApcDao().getLatestDescription(line.getPaymentApc());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getClaimDispositionDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getClaimDispositionDescription(OceClaim claim, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getDescription(claim.getClaimDisposition(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestClaimDispositionDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestClaimDispositionDescription(OceClaim claim) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDisposition().getLatestDescription(claim.getClaimDisposition());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getClaimDispositionValueDescription(String claimDispositionId, String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getDescription(claimDispositionId, value, version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getClaimDispositionValueDescription(String claimDispositionId, OceClaim claim, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getDescription(claimDispositionId, claim.getClaimDisposition(), version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestClaimDispositionValueDescription(String claimDispositionId, String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getLatestDescription(claimDispositionId, value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestClaimDispositionValueDescription(String claimDispositionId, OceClaim claim) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscClaimDispositionValue().getLatestDescription(claimDispositionId, claim.getClaimDisposition());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getClaimProcessedFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getClaimProcessedFlagDescription(OceClaim claim, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getDescription(claim.getClaimProcessedFlag(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestClaimProcessedFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestClaimProcessedFlagDescription(OceClaim claim) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscCpfDao().getLatestDescription(claim.getClaimProcessedFlag());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getDiscountFormulaDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getDiscountFormulaDescription(OceLineItem line, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getDescription(line.getDiscountingFormula(), (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestDiscountFormulaDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestDiscountFormulaDescription(OceLineItem line) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDiscountFormulaDao().getLatestDescription(line.getDiscountingFormula());
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getDiagnosisDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDx10Dao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestDiagnosisDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscDx10Dao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getEditDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestEditDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getEditDispositionDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDispositionDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestEditDispositionDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscEditDispositionDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getErrorDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscErrorDao().getDescription(value, version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestErrorDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscErrorDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getHcpcsDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscHcpcsDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestHcpcsDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscHcpcsDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getHcpcsModifierDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscModifierDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestHcpcsModifierDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscModifierDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLineItemActionFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLiafDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestLineItemActionFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLiafDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLineItemRejectionDenialFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLidrfDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestLineItemRejectionDenialFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscLidrfDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getPaymentAdjustmentFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPafDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestPaymentAdjustmentFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPafDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getPaymentIndicatorDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPaymentIndicatorDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestPaymentIndicatorDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPaymentIndicatorDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getPackagingFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPkgDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestPackagingFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPkgDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getPaymentMethodFlagDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPmfDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestPaymentMethodFlagDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscPmfDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getRevenueCodeDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscRevenueDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestRevenueCodeDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscRevenueDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getStatusIndicatorDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscStatusIndicatorDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestStatusIndicatorDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscStatusIndicatorDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getValueCodeDescription(String value, short version) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscValueCodeDao().getDescription(value, (Short)version);
        return StringUtilities.toNonNullTrimmedString(description);
    }

    public final synchronized String getLatestValueCodeDescription(String value) {
        DescriptionDaoFactory factory = this.claimProcessor.getResourceManager().getDescriptionDaoFactory();
        String description = factory.getDscValueCodeDao().getLatestDescription(value);
        return StringUtilities.toNonNullTrimmedString(description);
    }
}

