/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary;

import gov.cms.oce.dao.DataProvider;
import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.dao.data.row.DataCapcRowInternal;
import gov.cms.oce.dao.data.row.DataDiscountFormulaRowInternal;
import gov.cms.oce.dao.data.row.DataDx10RowInternal;
import gov.cms.oce.dao.data.row.DataEditBypassRowInternal;
import gov.cms.oce.dao.data.row.DataHcpcsRowInternal;
import gov.cms.oce.dao.data.row.DataModifierRowInternal;
import gov.cms.oce.dao.data.row.DataRevenueRowInternal;
import gov.cms.oce.dao.data.row.MapAddonCovidLabRowInternal;
import gov.cms.oce.dao.data.row.MapAddonDrugAdminRowInternal;
import gov.cms.oce.dao.data.row.MapAddonPhRowInternal;
import gov.cms.oce.dao.data.row.MapAddonSaaSRowInternal;
import gov.cms.oce.dao.data.row.MapAddonType1And3RowInternal;
import gov.cms.oce.dao.data.row.MapAddonType2RowInternal;
import gov.cms.oce.dao.data.row.MapBiosimilarRowInternal;
import gov.cms.oce.dao.data.row.MapCapcRowInternal;
import gov.cms.oce.dao.data.row.MapCompositeRowInternal;
import gov.cms.oce.dao.data.row.MapConflictRhcRowInternal;
import gov.cms.oce.dao.data.row.MapFqhcVisitRowInternal;
import gov.cms.oce.dao.data.row.MapModifierConflictRowInternal;
import gov.cms.oce.dao.data.row.MapNcciLeftCodesRowInternal;
import gov.cms.oce.dao.data.row.MapNcciRightCodesRowInternal;
import gov.cms.oce.dao.data.row.MapS603OverrideRowInternal;
import gov.cms.oce.dao.data.row.OffsetApcRowInternal;
import gov.cms.oce.dao.data.row.OffsetCodepairRowInternal;
import gov.cms.oce.dao.data.row.OffsetHcpcsRowInternal;
import gov.cms.oce.dao.data.row.VersionRangeRowInternal;
import gov.cms.oce.dao.data.table.DataApcTableInternal;
import gov.cms.oce.dao.data.table.DataCapcTableInternal;
import gov.cms.oce.dao.data.table.DataDiscountFormulaTableInternal;
import gov.cms.oce.dao.data.table.DataDx10TableInternal;
import gov.cms.oce.dao.data.table.DataEditBypassTableInternal;
import gov.cms.oce.dao.data.table.DataHcpcsTableInternal;
import gov.cms.oce.dao.data.table.DataModifierTableInternal;
import gov.cms.oce.dao.data.table.DataRevenueTableInternal;
import gov.cms.oce.dao.data.table.MapAddonCovidLabTableInternal;
import gov.cms.oce.dao.data.table.MapAddonDrugAdminTableInternal;
import gov.cms.oce.dao.data.table.MapAddonPhTableInternal;
import gov.cms.oce.dao.data.table.MapAddonSaaSTableInternal;
import gov.cms.oce.dao.data.table.MapAddonType1And3TableInternal;
import gov.cms.oce.dao.data.table.MapAddonType1TableInternal;
import gov.cms.oce.dao.data.table.MapAddonType2TableInternal;
import gov.cms.oce.dao.data.table.MapAddonType3TableInternal;
import gov.cms.oce.dao.data.table.MapBiosimilarTableInternal;
import gov.cms.oce.dao.data.table.MapCapcTableInternal;
import gov.cms.oce.dao.data.table.MapCompositeTableInternal;
import gov.cms.oce.dao.data.table.MapConflictRhcTableInternal;
import gov.cms.oce.dao.data.table.MapFqhcVisitTableInternal;
import gov.cms.oce.dao.data.table.MapModifierConflictTableInternal;
import gov.cms.oce.dao.data.table.MapNcciTableLeftCodesInternal;
import gov.cms.oce.dao.data.table.MapNcciTableRightCodesInternal;
import gov.cms.oce.dao.data.table.MapS603OverrideTableInternal;
import gov.cms.oce.dao.data.table.OffsetApcTableInternal;
import gov.cms.oce.dao.data.table.OffsetCodepairTableInternal;
import gov.cms.oce.dao.data.table.OffsetHcpcsTableInternal;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.ext.table.data.DataApcRow;
import gov.cms.oce.ext.table.data.DataCapcRow;
import gov.cms.oce.ext.table.data.DataDiscountFormulaRow;
import gov.cms.oce.ext.table.data.DataDx10Row;
import gov.cms.oce.ext.table.data.DataEditBypassRow;
import gov.cms.oce.ext.table.data.DataHcpcsRow;
import gov.cms.oce.ext.table.data.DataModifierRow;
import gov.cms.oce.ext.table.data.DataRevenueRow;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapAddonCovidLabRow;
import gov.cms.oce.ext.table.data.MapAddonDrugAdminRow;
import gov.cms.oce.ext.table.data.MapAddonPhRow;
import gov.cms.oce.ext.table.data.MapAddonSaaSRow;
import gov.cms.oce.ext.table.data.MapAddonType1Row;
import gov.cms.oce.ext.table.data.MapAddonType2Row;
import gov.cms.oce.ext.table.data.MapAddonType3Row;
import gov.cms.oce.ext.table.data.MapBiosimilarRow;
import gov.cms.oce.ext.table.data.MapCapcRow;
import gov.cms.oce.ext.table.data.MapCompositeRow;
import gov.cms.oce.ext.table.data.MapConflictRhcRow;
import gov.cms.oce.ext.table.data.MapFqhcVisitRow;
import gov.cms.oce.ext.table.data.MapModifierConflictRow;
import gov.cms.oce.ext.table.data.MapNcciRowLeftCodes;
import gov.cms.oce.ext.table.data.MapNcciRowRightCodes;
import gov.cms.oce.ext.table.data.MapNcciTableLeftCodes;
import gov.cms.oce.ext.table.data.MapNcciTableRightCodes;
import gov.cms.oce.ext.table.data.MapS603OverrideRow;
import gov.cms.oce.ext.table.data.OffsetApcRow;
import gov.cms.oce.ext.table.data.OffsetCodepairRow;
import gov.cms.oce.ext.table.data.OffsetHcpcsRow;
import gov.cms.oce.ext.table.data.VersionRangeRow;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinaryDataProvider
implements DataProvider {
    private static final Logger logger = LoggerFactory.getLogger(BinaryDataProvider.class);
    private static BinaryDataProvider dataProvider = BinaryDataProvider.getInstance();
    private VersionRangeTableInternal versionRangeTable;
    private DataApcTableInternal dataApcTable;
    private DataCapcTableInternal dataCapcTable;
    private DataDiscountFormulaTableInternal dataDiscountFormulaTable;
    private DataDx10TableInternal dataDx10Table;
    private DataEditBypassTableInternal dataEditBypassTable;
    private DataHcpcsTableInternal dataHcpcsTable;
    private DataModifierTableInternal dataModifierTable;
    private DataRevenueTableInternal dataRevenueTable;
    private MapAddonCovidLabTableInternal mapAddonCovidLabTable;
    private MapAddonDrugAdminTableInternal mapAddonDrugAdminTable;
    private MapAddonSaaSTableInternal mapAddonSaaSTable;
    private MapAddonPhTableInternal mapAddonPhTable;
    private MapAddonType1And3TableInternal mapAddonType1And3Table;
    private MapAddonType1TableInternal mapAddonType1Table;
    private MapAddonType2TableInternal mapAddonType2Table;
    private MapAddonType3TableInternal mapAddonType3Table;
    private MapBiosimilarTableInternal mapBiosimilarTable;
    private MapCapcTableInternal mapCapcTable;
    private MapCompositeTableInternal mapCompositeTable;
    private MapConflictRhcTableInternal mapConflictRhcTable;
    private MapFqhcVisitTableInternal mapFqhcVisitTable;
    private MapModifierConflictTableInternal mapModifierConflictTable;
    private MapNcciTableLeftCodesInternal mapNcciTableLeftCodes;
    private MapNcciTableRightCodesInternal mapNcciTableRightCodes;
    private MapS603OverrideTableInternal mapS603OverrideTable;
    private OffsetApcTableInternal offsetApcTable;
    private OffsetCodepairTableInternal offsetCodepairTable;
    private OffsetHcpcsTableInternal offsetHcpcsTable;
    private final FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);

    private BinaryDataProvider() {
        if (dataProvider != null) {
            throw new IllegalStateException("Illegal instantiation of class");
        }
    }

    public static final synchronized BinaryDataProvider getInstance() {
        if (dataProvider == null || BinaryDataProvider.dataProvider.flags.isNotSet(TableFlags.INITIALIZATION_SUCCESSFUL)) {
            dataProvider = new BinaryDataProvider();
            dataProvider.initialize();
        }
        return dataProvider;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    private final void initialize() {
        try (InputStream inputStream = BinaryDataProvider.class.getResourceAsStream("/ioce-data.bin");){
            DataSchema dataSchema = DataSchema.parseFrom(inputStream);
            this.loadVersionRangeTable(dataSchema);
            this.loadDataApcTable(dataSchema);
            this.loadDataCapcTable(dataSchema);
            this.loadDataDiscountFormulaTable(dataSchema);
            this.loadDataDx10Table(dataSchema);
            this.loadDataEditBypassTable(dataSchema);
            this.loadDataHcpcsTable(dataSchema);
            this.loadDataModifierTable(dataSchema);
            this.loadDataRevenueTable(dataSchema);
            this.loadMapAddonCovidLabTable(dataSchema);
            this.loadMapAddonDrugAdminTable(dataSchema);
            this.loadMapAddonSaaSTable(dataSchema);
            this.loadMapAddonPhTable(dataSchema);
            this.loadMapAddonType1And3Table(dataSchema);
            this.loadMapAddonType2Table(dataSchema);
            this.loadMapBiosimilarTable(dataSchema);
            this.loadMapCapcTable(dataSchema);
            this.loadMapCompositeTable(dataSchema);
            this.loadMapConflictRhcTable(dataSchema);
            this.loadMapFqhcVisitTable(dataSchema);
            this.loadMapModifierConflictTable(dataSchema);
            this.loadMapNcciTableLeftCodes(dataSchema.getMapNcciTableLeftCodes());
            this.loadMapNcciTableRightCodes(dataSchema.getMapNcciTableRightCodes());
            this.loadMapS603OverrideTable(dataSchema);
            this.loadOffsetApcTable(dataSchema);
            this.loadOffsetCodepairTable(dataSchema);
            this.loadOffsetHcpcsTable(dataSchema);
        }
        catch (IOException e) {
            logger.error("Failed to load table data", e);
        }
        if (this.isInitialized()) {
            if (logger.isInfoEnabled()) {
                logger.info("Table initialization succeeded.");
            }
            this.flags.set(TableFlags.INITIALIZATION_SUCCESSFUL);
        } else {
            logger.error("Table initialization failed.");
        }
    }

    public final synchronized boolean isInitialized() {
        return this.versionRangeTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataApcTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataCapcTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataDiscountFormulaTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataDx10Table.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataEditBypassTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataHcpcsTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataModifierTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.dataRevenueTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapAddonCovidLabTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapAddonDrugAdminTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapAddonPhTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapAddonType1And3Table.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapAddonType2Table.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapBiosimilarTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapCapcTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapCompositeTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapConflictRhcTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapFqhcVisitTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapModifierConflictTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapNcciTableLeftCodes.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapNcciTableRightCodes.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.mapS603OverrideTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.offsetApcTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.offsetCodepairTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL) && this.offsetHcpcsTable.getFlags().isSet(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final int getCapacityEstimate(int collectionSize) {
        return (int)Math.ceil((double)collectionSize * 0.3);
    }

    private final void loadVersionRangeTable(DataSchema data) {
        ArrayList<VersionRangeRowInternal> temporaryTable = new ArrayList<VersionRangeRowInternal>();
        for (VersionRangeRow row : data.getVersionRangeTable().getRowList()) {
            temporaryTable.add(new VersionRangeRowInternal((short)row.getVersion(), row.getDateStarted(), row.getDateEnded(), row.getVersionId()));
        }
        temporaryTable.trimToSize();
        this.versionRangeTable = new VersionRangeTableInternal(Collections.unmodifiableList(temporaryTable));
        this.versionRangeTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataApcTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataApcTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataApcRow row : data.getDataApcTable().getRowList()) {
            Map<DataApcTableInternal.DataApcTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataApcTableInternal.DataApcTableKey.class);
            tableKey.put(DataApcTableInternal.DataApcTableKey.APC, row.getApc());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataApcRowInternal(row.getApc(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getStatusIndicator(), (byte)row.getPaymentIndicator(), row.getApcPayment(), row.getMentalHealth(), row.getErVisit(), row.getDeviceOffset(), (byte)row.getComp1Id(), (byte)row.getComp2Id(), (byte)row.getComp3Id(), row.getCapcSrs()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataApcTable = new DataApcTableInternal(Collections.unmodifiableMap(finalTable));
        this.dataApcTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataCapcTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataCapcTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataCapcRow row : data.getDataCapcTable().getRowList()) {
            Map<DataCapcTableInternal.DataCapcTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataCapcTableInternal.DataCapcTableKey.class);
            tableKey.put(DataCapcTableInternal.DataCapcTableKey.HCPCS, row.getHcpcs());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataCapcRowInternal(row.getHcpcs(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getRank(), row.getComplexityAdjustment()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataCapcTable = new DataCapcTableInternal(Collections.unmodifiableMap(finalTable));
        this.dataCapcTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataDiscountFormulaTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataDiscountFormulaTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataDiscountFormulaRow row : data.getDataDiscountFormulaTable().getRowList()) {
            Map<DataDiscountFormulaTableInternal.DataDiscountFormulaTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataDiscountFormulaTableInternal.DataDiscountFormulaTableKey.class);
            tableKey.put(DataDiscountFormulaTableInternal.DataDiscountFormulaTableKey.DISCOUNT_KEY, row.getDiscountKey());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataDiscountFormulaRowInternal(row.getDiscountKey(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDiscountFormula()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataDiscountFormulaTable = new DataDiscountFormulaTableInternal(Collections.unmodifiableMap(finalTable));
        this.dataDiscountFormulaTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataDx10Table(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataDx10Table().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataDx10Row row : data.getDataDx10Table().getRowList()) {
            Map<DataDx10TableInternal.DataDx10TableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataDx10TableInternal.DataDx10TableKey.class);
            tableKey.put(DataDx10TableInternal.DataDx10TableKey.DIAGNOSIS, row.getDiagnosis());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataDx10RowInternal(row.getDiagnosis(), (short)row.getLoVersion(), (short)row.getHiVersion(), (byte)row.getLoAge(), (byte)row.getHiAge(), (byte)row.getSex(), row.getExternalCause(), row.getMentalHealth(), row.getManifestation(), row.getCodeFirst(), row.getUnacceptablePdx(), row.getUnacceptablePdxExclusion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataDx10Table = new DataDx10TableInternal(Collections.unmodifiableMap(finalTable));
        this.dataDx10Table.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataEditBypassTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataDx10Table().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataEditBypassRow row : data.getDataEditBypassTable().getRowList()) {
            Map<DataEditBypassTableInternal.DataEditBypassTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataEditBypassTableInternal.DataEditBypassTableKey.class);
            tableKey.put(DataEditBypassTableInternal.DataEditBypassTableKey.EDIT, String.valueOf(row.getEdit()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataEditBypassRowInternal((short)row.getEdit(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getLineBypassRequired()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataEditBypassTable = new DataEditBypassTableInternal(Collections.unmodifiableMap(finalTable));
        this.dataEditBypassTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataHcpcsTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataHcpcsTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataHcpcsRow row : data.getDataHcpcsTable().getRowList()) {
            Map<DataHcpcsTableInternal.DataHcpcsTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataHcpcsTableInternal.DataHcpcsTableKey.class);
            tableKey.put(DataHcpcsTableInternal.DataHcpcsTableKey.HCPCS, row.getHcpcs());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataHcpcsRowInternal(row.getHcpcs(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getApc(), (byte)row.getLoAge(), (byte)row.getHiAge(), (byte)row.getSex(), row.getStatusIndicator(), (byte)row.getPaymentIndicator(), row.getQuestionable(), row.getNotRecognizedMcare(), row.getNotRecognizedOpps(), row.getNonCovered(), row.getNonReportableSite(), row.getBilateralConditional(), row.getBilateralIndependent(), row.getBilateralInherent(), row.getNcciCode1(), row.getNcciCode2(), row.getVaccine(), row.getAntigen(), row.getSplint(), row.getCast(), row.getNegativePressureWoundTherapy(), row.getSometimesTherapy(), row.getActivityTherapy(), row.getOccupationalTherapy(), row.getDeductibleNa(), row.getDeductibleCoinsNa(), row.getCoinsNa(), row.getBloodService(), row.getBloodProduct(), row.getPackedRedCells(), row.getWholeBlood(), row.getEducational(), row.getObservation(), row.getObservationHourly(), row.getObservationDirectAdmit(), row.getObservationHospitalOnly(), row.getTraumaRevenueCode(), row.getTraumaCriticalCare(), row.getCriticalCareAncillary(), row.getStvPackaged(), row.getTPackaged(), row.getHasDevReqProc(), row.getSeparateProcedure(), row.getStatutoryExclusion(), row.getDmercBillableOnly(), row.getUnclassifiedDrug(), row.getRadioPharm(), row.getNuclearMed(), (short)row.getMidQuarterDateEdit(), row.getDateApproved(), row.getDateTerminated(), row.getNonBillableMac(), row.getHasDevicePair1(), row.getHasDevicePair2(), row.getPhPrimary(), row.getPhService(), row.getDailyMentalHealth(), row.getMhNotPh(), row.getPhNotMh(), (byte)row.getPhDuration(), row.getPhAddon(), row.getTokenChargeOnly(), row.getSkinSubstituteSg(), row.getSkinSubstitute(), row.getCapcExclusion(), row.getCapcSrsPlanAndPrep(), row.getDeviceProcedure(), row.getDevice(), row.getSkinSubstituteSgLo(), row.getSkinSubstituteLo(), row.getSkinSubstituteSgHi(), row.getSkinSubstituteHi(), row.getLabService(), row.getFqhcPreventive(), row.getFqhcFluPpv(), row.getFqhcNonCovered(), row.getFqhcAddon(), row.getFqhcPrimary(), row.getFqhcChronicCare(), row.getRhcModifierConflict(), row.getBypassE72FqhcRhc(), row.getDevProcBypass(), row.getCorneaTransplant(), row.getCorneaTissueProcessing(), row.getAdvanceCarePlanning(), row.getAnnualWellnessvisit(), row.getTerminatedDeviceProcedure(), row.getPassthroughDevice(), row.getPassthroughRadiopharm(), row.getPassthroughSkinProduct(), row.getPassthroughContrast(), row.getPassthroughStressAgent(), row.getNonStandardCtScan(), row.getFilmXray(), row.getAllogeneicTransplant(), row.getBypassE99(), row.getOverrideSection603(), row.getAddonType1(), row.getAddonType2(), row.getAddonType3(), row.getBiosimilar(), row.getBundledInBiological(), row.getBypassE92Modifier(), row.getAddonDrugAdmin(), row.getInformationOnly(), row.getRadiationOncologyModel(), row.getCoinsuranceDeductibleWaiverEligible(), row.getAddonCovidLab(), row.getOpioidTreatmentProgram(), row.getOpioidUseDisorder(), row.getColorectalScreening(), row.getCmsMidQuarterTermination(), row.getCmsMidQuarterTerminationBypass(), row.getRemoteMentalHealth(), row.getAddonSaaS()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataHcpcsTable = new DataHcpcsTableInternal(Collections.unmodifiableMap(finalTable));
        this.dataHcpcsTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataModifierTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataModifierTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataModifierRow row : data.getDataModifierTable().getRowList()) {
            Map<DataModifierTableInternal.DataModifierTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataModifierTableInternal.DataModifierTableKey.class);
            tableKey.put(DataModifierTableInternal.DataModifierTableKey.MODIFIER, row.getModifier());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataModifierRowInternal(row.getModifier(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getDateActivated(), row.getNcci(), row.getTherapy(), row.getNonDiscount(), row.getDiedTransferred(), row.getDeviceReqExclusion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataModifierTable = new DataModifierTableInternal(Collections.unmodifiableMap(finalTable));
        this.dataModifierTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadDataRevenueTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getDataModifierTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (DataRevenueRow row : data.getDataRevenueTable().getRowList()) {
            Map<DataRevenueTableInternal.DataRevenueTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(DataRevenueTableInternal.DataRevenueTableKey.class);
            tableKey.put(DataRevenueTableInternal.DataRevenueTableKey.REVENUE_CODE, String.valueOf(row.getRevenueCode()));
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new DataRevenueRowInternal((short)row.getRevenueCode(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getStatusIndicator(), row.getNotRecognized(), row.getTherapy(), row.getBypassE48(), row.getStatutoryExclusion(), row.getBundledInBiological()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.dataRevenueTable = new DataRevenueTableInternal(Collections.unmodifiableMap(finalTable));
        this.dataRevenueTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapAddonCovidLabTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapAddonCovidLabTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapAddonCovidLabRow row : data.getMapAddonCovidLabTable().getRowList()) {
            Map<MapAddonCovidLabTableInternal.MapAddonCovidLabTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapAddonCovidLabTableInternal.MapAddonCovidLabTableKey.class);
            tableKey.put(MapAddonCovidLabTableInternal.MapAddonCovidLabTableKey.ADDON, row.getAddon());
            tableKey.put(MapAddonCovidLabTableInternal.MapAddonCovidLabTableKey.ADDON_PRIMARY, row.getAddonPrimary());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapAddonCovidLabRowInternal(row.getAddon(), row.getAddonPrimary(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapAddonCovidLabTable = new MapAddonCovidLabTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapAddonCovidLabTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapAddonSaaSTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapAddonSaaSTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapAddonSaaSRow row : data.getMapAddonSaaSTable().getRowList()) {
            Map<MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey.class);
            tableKey.put(MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey.ADDON, row.getAddon());
            tableKey.put(MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey.ADDON_PRIMARY, row.getAddonPrimary());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapAddonSaaSRowInternal(row.getAddon(), row.getAddonPrimary(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapAddonSaaSTable = new MapAddonSaaSTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapAddonSaaSTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapAddonDrugAdminTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapAddonDrugAdminTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapAddonDrugAdminRow row : data.getMapAddonDrugAdminTable().getRowList()) {
            Map<MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey.class);
            tableKey.put(MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey.ADDON, row.getAddon());
            tableKey.put(MapAddonDrugAdminTableInternal.MapAddonDrugAdminTableKey.ADDON_PRIMARY, row.getAddonPrimary());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapAddonDrugAdminRowInternal(row.getAddon(), row.getAddonPrimary(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapAddonDrugAdminTable = new MapAddonDrugAdminTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapAddonDrugAdminTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapAddonPhTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapAddonPhTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapAddonPhRow row : data.getMapAddonPhTable().getRowList()) {
            Map<MapAddonPhTableInternal.MapAddonPhTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapAddonPhTableInternal.MapAddonPhTableKey.class);
            tableKey.put(MapAddonPhTableInternal.MapAddonPhTableKey.ADDON, row.getAddon());
            tableKey.put(MapAddonPhTableInternal.MapAddonPhTableKey.ADDON_PRIMARY, row.getAddonPrimary());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapAddonPhRowInternal(row.getAddon(), row.getAddonPrimary(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapAddonPhTable = new MapAddonPhTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapAddonPhTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapAddonType1And3Table(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapAddonType1Table().getRowCount() + data.getMapAddonType3Table().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        boolean addonType1 = true;
        for (MapAddonType1Row mapAddonType1Row : data.getMapAddonType1Table().getRowList()) {
            Map<MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey.class);
            tableKey.put(MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey.ADDON, mapAddonType1Row.getAddon());
            tableKey.put(MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey.ADDON_PRIMARY, mapAddonType1Row.getAddonPrimary());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapAddonType1And3RowInternal(mapAddonType1Row.getAddon(), mapAddonType1Row.getAddonPrimary(), 1, (short)mapAddonType1Row.getLoVersion(), (short)mapAddonType1Row.getHiVersion()));
        }
        int addonType3 = 3;
        for (MapAddonType3Row row : data.getMapAddonType3Table().getRowList()) {
            Map<MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey.class);
            tableKey.put(MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey.ADDON, row.getAddon());
            tableKey.put(MapAddonType1And3TableInternal.MapAddonType1And3AddonTableKey.ADDON_PRIMARY, row.getAddonPrimary());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapAddonType1And3RowInternal(row.getAddon(), row.getAddonPrimary(), 3, (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            linkedHashMap.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapAddonType1And3Table = new MapAddonType1And3TableInternal(Collections.unmodifiableMap(linkedHashMap));
        this.mapAddonType1And3Table.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapAddonType2Table(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapAddonType2Table().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapAddonType2Row row : data.getMapAddonType2Table().getRowList()) {
            Map<MapAddonType2TableInternal.MapAddonType2TableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapAddonType2TableInternal.MapAddonType2TableKey.class);
            tableKey.put(MapAddonType2TableInternal.MapAddonType2TableKey.ADDON, row.getAddon());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapAddonType2RowInternal(row.getAddon(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapAddonType2Table = new MapAddonType2TableInternal(Collections.unmodifiableMap(finalTable));
        this.mapAddonType2Table.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapBiosimilarTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapBiosimilarTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapBiosimilarRow row : data.getMapBiosimilarTable().getRowList()) {
            Map<MapBiosimilarTableInternal.MapBiosimilarTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapBiosimilarTableInternal.MapBiosimilarTableKey.class);
            tableKey.put(MapBiosimilarTableInternal.MapBiosimilarTableKey.HCPCS, row.getHcpcs());
            tableKey.put(MapBiosimilarTableInternal.MapBiosimilarTableKey.MODIFIER, row.getModifier());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapBiosimilarRowInternal(row.getHcpcs(), row.getModifier(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapBiosimilarTable = new MapBiosimilarTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapBiosimilarTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapCapcTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapCapcTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapCapcRow row : data.getMapCapcTable().getRowList()) {
            Map<MapCapcTableInternal.MapCapcTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapCapcTableInternal.MapCapcTableKey.class);
            tableKey.put(MapCapcTableInternal.MapCapcTableKey.CODE1, row.getCode1());
            tableKey.put(MapCapcTableInternal.MapCapcTableKey.CODE2, row.getCode2());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapCapcRowInternal(row.getCode1(), row.getCode2(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getApc()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapCapcTable = new MapCapcTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapCapcTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapCompositeTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapCompositeTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapCompositeRow row : data.getMapCompositeTable().getRowList()) {
            Map<MapCompositeTableInternal.MapCompositeTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapCompositeTableInternal.MapCompositeTableKey.class);
            tableKey.put(MapCompositeTableInternal.MapCompositeTableKey.HCPCS, row.getHcpcs());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapCompositeRowInternal(row.getHcpcs(), row.getCompositeApc(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getListType()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapCompositeTable = new MapCompositeTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapCompositeTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapConflictRhcTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapConflictRhcTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapConflictRhcRow row : data.getMapConflictRhcTable().getRowList()) {
            Map<MapConflictRhcTableInternal.MapConflictRhcTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapConflictRhcTableInternal.MapConflictRhcTableKey.class);
            tableKey.put(MapConflictRhcTableInternal.MapConflictRhcTableKey.HCPCS, row.getHcpcs());
            tableKey.put(MapConflictRhcTableInternal.MapConflictRhcTableKey.MODIFIER, row.getModifier());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapConflictRhcRowInternal(row.getHcpcs(), row.getModifier(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapConflictRhcTable = new MapConflictRhcTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapConflictRhcTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapFqhcVisitTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapFqhcVisitTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapFqhcVisitRow row : data.getMapFqhcVisitTable().getRowList()) {
            Map<MapFqhcVisitTableInternal.MapFqhcVisitTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapFqhcVisitTableInternal.MapFqhcVisitTableKey.class);
            tableKey.put(MapFqhcVisitTableInternal.MapFqhcVisitTableKey.CODE1, row.getCode1());
            tableKey.put(MapFqhcVisitTableInternal.MapFqhcVisitTableKey.CODE2, row.getCode2());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapFqhcVisitRowInternal(row.getCode1(), row.getCode2(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapFqhcVisitTable = new MapFqhcVisitTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapFqhcVisitTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapModifierConflictTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapModifierConflictTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapModifierConflictRow row : data.getMapModifierConflictTable().getRowList()) {
            Map<MapModifierConflictTableInternal.MapModifierConflictTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapModifierConflictTableInternal.MapModifierConflictTableKey.class);
            tableKey.put(MapModifierConflictTableInternal.MapModifierConflictTableKey.MODIFIER1, row.getModifier1());
            tableKey.put(MapModifierConflictTableInternal.MapModifierConflictTableKey.MODIFIER2, row.getModifier2());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapModifierConflictRowInternal(row.getModifier1(), row.getModifier2(), (short)row.getLoVersion(), (short)row.getHiVersion()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapModifierConflictTable = new MapModifierConflictTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapModifierConflictTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapNcciTableLeftCodes(MapNcciTableLeftCodes data) {
        int capacityEstimate = this.getCapacityEstimate(data.getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapNcciRowLeftCodes row : data.getRowList()) {
            String key = row.getCode();
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapNcciLeftCodesRowInternal(row.getCode(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getModIndicator(), (short)row.getGroupId()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapNcciTableLeftCodes = new MapNcciTableLeftCodesInternal(Collections.unmodifiableMap(finalTable));
        this.mapNcciTableLeftCodes.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapNcciTableRightCodes(MapNcciTableRightCodes data) {
        int capacityEstimate = this.getCapacityEstimate(data.getRowCount());
        LinkedHashMap<String, MapNcciRightCodesRowInternal> temporaryTable = new LinkedHashMap<String, MapNcciRightCodesRowInternal>(capacityEstimate);
        for (MapNcciRowRightCodes row : data.getRowList()) {
            Map<MapNcciTableRightCodesInternal.MapNcciTableRightCodesKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapNcciTableRightCodesInternal.MapNcciTableRightCodesKey.class);
            tableKey.put(MapNcciTableRightCodesInternal.MapNcciTableRightCodesKey.GROUP_ID, String.valueOf(row.getGroupId()));
            tableKey.put(MapNcciTableRightCodesInternal.MapNcciTableRightCodesKey.CODE, row.getCode());
            String key = TableKeyBuilder.createTableKey(tableKey);
            if (temporaryTable.containsKey(key)) {
                throw new RuntimeException("Right-side code table contains duplicate entry for key " + key + " (code=" + row.getCode() + ", groupId=" + row.getGroupId() + "");
            }
            temporaryTable.put(key, new MapNcciRightCodesRowInternal(row.getCode(), (short)row.getGroupId()));
        }
        this.mapNcciTableRightCodes = new MapNcciTableRightCodesInternal(Collections.unmodifiableMap(temporaryTable));
        this.mapNcciTableRightCodes.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadMapS603OverrideTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getMapS603OverrideTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (MapS603OverrideRow row : data.getMapS603OverrideTable().getRowList()) {
            Map<MapS603OverrideTableInternal.MapS603OverrideTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(MapS603OverrideTableInternal.MapS603OverrideTableKey.class);
            tableKey.put(MapS603OverrideTableInternal.MapS603OverrideTableKey.HCPCS, row.getHcpcs());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new MapS603OverrideRowInternal(row.getHcpcs(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getApc()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.mapS603OverrideTable = new MapS603OverrideTableInternal(Collections.unmodifiableMap(finalTable));
        this.mapS603OverrideTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadOffsetApcTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getOffsetApcTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (OffsetApcRow row : data.getOffsetApcTable().getRowList()) {
            Map<OffsetApcTableInternal.OffsetApcTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(OffsetApcTableInternal.OffsetApcTableKey.class);
            tableKey.put(OffsetApcTableInternal.OffsetApcTableKey.GROUP_ID, String.valueOf(row.getGroupId()));
            tableKey.put(OffsetApcTableInternal.OffsetApcTableKey.LIST_ID, String.valueOf(row.getListId()));
            tableKey.put(OffsetApcTableInternal.OffsetApcTableKey.APC, row.getApc());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new OffsetApcRowInternal((byte)row.getGroupId(), (byte)row.getListId(), row.getApc(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getAmount()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.offsetApcTable = new OffsetApcTableInternal(Collections.unmodifiableMap(finalTable));
        this.offsetApcTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadOffsetCodepairTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getOffsetCodepairTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (OffsetCodepairRow row : data.getOffsetCodepairTable().getRowList()) {
            Map<OffsetCodepairTableInternal.OffsetCodepairTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(OffsetCodepairTableInternal.OffsetCodepairTableKey.class);
            tableKey.put(OffsetCodepairTableInternal.OffsetCodepairTableKey.LIST_ID, String.valueOf(row.getListId()));
            tableKey.put(OffsetCodepairTableInternal.OffsetCodepairTableKey.CODE1, row.getCode1());
            tableKey.put(OffsetCodepairTableInternal.OffsetCodepairTableKey.CODE2, row.getCode2());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new OffsetCodepairRowInternal((byte)row.getListId(), row.getCode1(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getCode2(), row.getAmount(), row.getDateActivated()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.offsetCodepairTable = new OffsetCodepairTableInternal(Collections.unmodifiableMap(finalTable));
        this.offsetCodepairTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    private final void loadOffsetHcpcsTable(DataSchema data) {
        int capacityEstimate = this.getCapacityEstimate(data.getOffsetHcpcsTable().getRowCount());
        LinkedHashMap<String, List> temporaryTable = new LinkedHashMap<String, List>(capacityEstimate);
        for (OffsetHcpcsRow row : data.getOffsetHcpcsTable().getRowList()) {
            Map<OffsetHcpcsTableInternal.OffsetHcpcsTableKey, String> tableKey = TableKeyBuilder.createTableKeyMap(OffsetHcpcsTableInternal.OffsetHcpcsTableKey.class);
            tableKey.put(OffsetHcpcsTableInternal.OffsetHcpcsTableKey.LIST_ID, String.valueOf(row.getListId()));
            tableKey.put(OffsetHcpcsTableInternal.OffsetHcpcsTableKey.HCPCS, row.getHcpcs());
            String key = TableKeyBuilder.createTableKey(tableKey);
            List list = temporaryTable.computeIfAbsent(key, v -> new ArrayList());
            list.add(new OffsetHcpcsRowInternal((byte)row.getListId(), row.getHcpcs(), (short)row.getLoVersion(), (short)row.getHiVersion(), row.getAmount()));
        }
        LinkedHashMap finalTable = new LinkedHashMap(capacityEstimate);
        for (Map.Entry entry : temporaryTable.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            value.trimToSize();
            finalTable.put(entry.getKey(), Collections.unmodifiableList(value));
        }
        temporaryTable.clear();
        this.offsetHcpcsTable = new OffsetHcpcsTableInternal(Collections.unmodifiableMap(finalTable));
        this.offsetHcpcsTable.getFlags().set(TableFlags.INITIALIZATION_SUCCESSFUL);
    }

    public final VersionRangeTableInternal getVersionRangeTable() {
        return this.versionRangeTable;
    }

    public final DataApcTableInternal getDataApcTable() {
        return this.dataApcTable;
    }

    public final DataCapcTableInternal getDataCapcTable() {
        return this.dataCapcTable;
    }

    public final DataDiscountFormulaTableInternal getDataDiscountFormulaTable() {
        return this.dataDiscountFormulaTable;
    }

    public final DataDx10TableInternal getDataDx10Table() {
        return this.dataDx10Table;
    }

    public final DataEditBypassTableInternal getDataEditBypassTable() {
        return this.dataEditBypassTable;
    }

    public final DataHcpcsTableInternal getDataHcpcsTable() {
        return this.dataHcpcsTable;
    }

    public final DataModifierTableInternal getDataModifierTable() {
        return this.dataModifierTable;
    }

    public final DataRevenueTableInternal getDataRevenueTable() {
        return this.dataRevenueTable;
    }

    public final MapAddonCovidLabTableInternal getMapAddonCovidLabTable() {
        return this.mapAddonCovidLabTable;
    }

    public final MapAddonDrugAdminTableInternal getMapAddonDrugAdminTable() {
        return this.mapAddonDrugAdminTable;
    }

    public final MapAddonSaaSTableInternal getMapAddonSaaSTable() {
        return this.mapAddonSaaSTable;
    }

    public final MapAddonPhTableInternal getMapAddonPhTable() {
        return this.mapAddonPhTable;
    }

    public final MapAddonType1And3TableInternal getMapAddonType1And3Table() {
        return this.mapAddonType1And3Table;
    }

    public final MapAddonType1TableInternal getMapAddonType1Table() {
        return this.mapAddonType1Table;
    }

    public final MapAddonType2TableInternal getMapAddonType2Table() {
        return this.mapAddonType2Table;
    }

    public final MapAddonType3TableInternal getMapAddonType3Table() {
        return this.mapAddonType3Table;
    }

    public final MapBiosimilarTableInternal getMapBiosimilarTable() {
        return this.mapBiosimilarTable;
    }

    public final MapCapcTableInternal getMapCapcTable() {
        return this.mapCapcTable;
    }

    public final MapCompositeTableInternal getMapCompositeTable() {
        return this.mapCompositeTable;
    }

    public final MapConflictRhcTableInternal getMapConflictRhcTable() {
        return this.mapConflictRhcTable;
    }

    public final MapFqhcVisitTableInternal getMapFqhcVisitTable() {
        return this.mapFqhcVisitTable;
    }

    public final MapModifierConflictTableInternal getMapModifierConflictTable() {
        return this.mapModifierConflictTable;
    }

    public final MapNcciTableLeftCodesInternal getMapNcciTableLeftCodes() {
        return this.mapNcciTableLeftCodes;
    }

    public final MapNcciTableRightCodesInternal getMapNcciTableRightCodes() {
        return this.mapNcciTableRightCodes;
    }

    public final MapS603OverrideTableInternal getMapS603OverrideTable() {
        return this.mapS603OverrideTable;
    }

    public final OffsetApcTableInternal getOffsetApcTable() {
        return this.offsetApcTable;
    }

    public final OffsetCodepairTableInternal getOffsetCodepairTable() {
        return this.offsetCodepairTable;
    }

    public final OffsetHcpcsTableInternal getOffsetHcpcsTable() {
        return this.offsetHcpcsTable;
    }
}

