/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.data.VersionRangeDaoImpl;
import gov.cms.oce.dao.data.DataDx10Dao;
import gov.cms.oce.dao.data.row.DataDx10RowInternal;
import gov.cms.oce.dao.data.table.DataDx10TableInternal;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.DiagnosisTableData;
import gov.cms.oce.model.internal.Version;
import gov.cms.oce.model.rsc.DiagnosisFlags;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.StringUtilities;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataDx10DaoImpl
implements DataDx10Dao {
    private static final Logger logger = LoggerFactory.getLogger(DataDx10DaoImpl.class);

    @Override
    public final DataDx10RowInternal getRow(String value, Short version) {
        if (StringUtilities.isEmpty(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Diagnosis parameter value is null/empty.");
            }
            return null;
        }
        Map<DataDx10TableInternal.DataDx10TableKey, String> key = TableKeyBuilder.createTableKeyMap(DataDx10TableInternal.DataDx10TableKey.class);
        key.put(DataDx10TableInternal.DataDx10TableKey.DIAGNOSIS, value);
        DataDx10TableInternal table = BinaryDataProvider.getInstance().getDataDx10Table();
        DataDx10RowInternal row = table.getRowInternal(key, version);
        if (row == null && logger.isDebugEnabled()) {
            logger.debug("Dx10 parameter value \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
        }
        return row;
    }

    @Override
    public final DataDx10RowInternal getRow(DiagnosisCode diagnosisCode, Short version) {
        return this.getRow(diagnosisCode.getValue(), version);
    }

    @Override
    public final void loadData(DiagnosisCode diagnosisCode, Short version, ClaimDate dateEnded) {
        if (diagnosisCode.getFlags().anySet(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS, DiagnosisFlags.INPUT_EMPTY_DIAGNOSIS)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No table data loaded as the diagnosis code is either blank or invalid.");
            }
        } else {
            VersionRangeDaoImpl versionRangeDao;
            Version dateEndedVersion;
            Map<DataDx10TableInternal.DataDx10TableKey, String> key = TableKeyBuilder.createTableKeyMap(DataDx10TableInternal.DataDx10TableKey.class);
            key.put(DataDx10TableInternal.DataDx10TableKey.DIAGNOSIS, diagnosisCode.getValue());
            DataDx10TableInternal table = BinaryDataProvider.getInstance().getDataDx10Table();
            DataDx10RowInternal row = table.getRowInternal(key, version);
            boolean versionBoundaryCrossed = false;
            if (row == null && dateEnded != null && (dateEndedVersion = (versionRangeDao = new VersionRangeDaoImpl()).getVersion(dateEnded)) != null && version == dateEndedVersion.getValue() - 1) {
                row = table.getRowInternal(key, dateEndedVersion.getValue());
                versionBoundaryCrossed = true;
            }
            if (row == null) {
                diagnosisCode.getFlags().set(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS);
                if (logger.isDebugEnabled()) {
                    logger.debug("Diagnosis value \"{}\" is missing from table for version \"{}\".", (Object)diagnosisCode.getValue(), (Object)version);
                }
            } else if (versionBoundaryCrossed) {
                diagnosisCode.getFlags().set(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS);
                diagnosisCode.getFlags().set(DiagnosisFlags.DIAGNOSIS_VALID_IN_FUTURE_VERSION);
                DiagnosisTableData tableData = diagnosisCode.getTableData();
                tableData.setLowAge((byte)0);
                tableData.setHighAge((byte)124);
                tableData.setSex((byte)0);
            } else {
                FlagSet<DiagnosisFlags> flags = diagnosisCode.getFlags();
                if (row.isExternalCause()) {
                    flags.set(DiagnosisFlags.EXTERNAL_CAUSE);
                }
                if (row.isMentalHealth()) {
                    flags.set(DiagnosisFlags.MENTAL_HEALTH);
                }
                if (row.isManifestation()) {
                    flags.set(DiagnosisFlags.MANIFESTATION);
                }
                if (row.isCodeFirst()) {
                    flags.set(DiagnosisFlags.CODE_FIRST);
                }
                if (row.isUnacceptablePdx()) {
                    flags.set(DiagnosisFlags.UNACCEPTABLE_PDX);
                }
                if (row.isUnacceptablePdxExclusion()) {
                    flags.set(DiagnosisFlags.UNACCEPTABLE_PDX_EXCLUSION);
                }
                DiagnosisTableData tableData = diagnosisCode.getTableData();
                tableData.setLowAge(row.getLoAge());
                tableData.setHighAge(row.getHiAge());
                tableData.setSex(row.getSex());
            }
        }
    }
}

