/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.MapCompositeDao;
import gov.cms.oce.dao.data.row.MapCompositeRowInternal;
import gov.cms.oce.dao.data.table.MapCompositeTableInternal;
import gov.cms.oce.model.internal.Hcpcs;
import gov.cms.oce.util.StringUtilities;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapCompositeDaoImpl
implements MapCompositeDao {
    private static final Logger logger = LoggerFactory.getLogger(MapCompositeDaoImpl.class);

    @Override
    public final MapCompositeRowInternal getRow(String hcpcs, Short version) {
        if (StringUtilities.isEmpty(hcpcs)) {
            if (logger.isDebugEnabled()) {
                logger.debug("CPT/HCPCS parameter value is null/empty.");
            }
            return null;
        }
        Map<MapCompositeTableInternal.MapCompositeTableKey, String> key = TableKeyBuilder.createTableKeyMap(MapCompositeTableInternal.MapCompositeTableKey.class);
        key.put(MapCompositeTableInternal.MapCompositeTableKey.HCPCS, hcpcs);
        MapCompositeTableInternal table = BinaryDataProvider.getInstance().getMapCompositeTable();
        MapCompositeRowInternal row = table.getRowInternal(key, version);
        if (row == null && logger.isDebugEnabled()) {
            logger.debug("CPT/HCPCS parameter value \"{}\" is missing from table for version \"{}\".", (Object)hcpcs, (Object)version);
        }
        return row;
    }

    @Override
    public final MapCompositeRowInternal getRow(Hcpcs hcpcs, Short version) {
        return this.getRow(hcpcs.getValue(), version);
    }
}

