/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscErrorRowInternal;
import gov.cms.oce.dao.desc.table.DscErrorTableInternal;
import gov.cms.oce.dao.dsc.DscErrorDao;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscErrorDaoImpl
implements DscErrorDao {
    private static final Logger logger = LoggerFactory.getLogger(DscErrorDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error parameter is null/empty.");
            }
            return "";
        }
        Map<DscErrorTableInternal.DscErrorTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscErrorTableInternal.DscErrorTableKey.class);
        key.put(DscErrorTableInternal.DscErrorTableKey.VALUE, value);
        DscErrorTableInternal table = BinaryDescriptionProvider.getInstance().getDscErrorTable();
        DscErrorRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for error code \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error parameter is null/empty.");
            }
            return "";
        }
        Map<DscErrorTableInternal.DscErrorTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscErrorTableInternal.DscErrorTableKey.class);
        key.put(DscErrorTableInternal.DscErrorTableKey.VALUE, value);
        DscErrorTableInternal table = BinaryDescriptionProvider.getInstance().getDscErrorTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscErrorRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for error code \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }
}

