/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscLidrfRowInternal;
import gov.cms.oce.dao.desc.table.DscLidrfTableInternal;
import gov.cms.oce.dao.dsc.DscLidrfDao;
import gov.cms.oce.model.internal.RejectionDenialFlag;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscLidrfDaoImpl
implements DscLidrfDao {
    private static final Logger logger = LoggerFactory.getLogger(DscLidrfDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Line item denial/rejection flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscLidrfTableInternal.DscLidrfTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscLidrfTableInternal.DscLidrfTableKey.class);
        key.put(DscLidrfTableInternal.DscLidrfTableKey.VALUE, value);
        DscLidrfTableInternal table = BinaryDescriptionProvider.getInstance().getDscLidrfTable();
        DscLidrfRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for line item denial/rejection flag \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(RejectionDenialFlag rejectionDenialFlag, Short version) {
        String description = this.getDescription(String.valueOf(rejectionDenialFlag.getValue()), version);
        rejectionDenialFlag.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Line item denial/rejection flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscLidrfTableInternal.DscLidrfTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscLidrfTableInternal.DscLidrfTableKey.class);
        key.put(DscLidrfTableInternal.DscLidrfTableKey.VALUE, value);
        DscLidrfTableInternal table = BinaryDescriptionProvider.getInstance().getDscLidrfTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscLidrfRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for line item denial/rejection flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(RejectionDenialFlag rejectionDenialFlag) {
        String description = this.getLatestDescription(String.valueOf(rejectionDenialFlag.getValue()));
        rejectionDenialFlag.setDescription(description);
        return description;
    }
}

