/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscModifierRowInternal;
import gov.cms.oce.dao.desc.table.DscModifierTableInternal;
import gov.cms.oce.dao.dsc.DscModifierDao;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscModifierDaoImpl
implements DscModifierDao {
    private static final Logger logger = LoggerFactory.getLogger(DscModifierDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment indicator parameter is null/empty.");
            }
            return "";
        }
        Map<DscModifierTableInternal.DscModifierTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscModifierTableInternal.DscModifierTableKey.class);
        key.put(DscModifierTableInternal.DscModifierTableKey.MODIFIER, value);
        DscModifierTableInternal table = BinaryDescriptionProvider.getInstance().getDscModifierTable();
        DscModifierRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for payment indicator \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(HcpcsModifier hcpcsModifier, Short version) {
        String description = this.getDescription(hcpcsModifier.getValue(), version);
        hcpcsModifier.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment indicator parameter is null/empty.");
            }
            return "";
        }
        Map<DscModifierTableInternal.DscModifierTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscModifierTableInternal.DscModifierTableKey.class);
        key.put(DscModifierTableInternal.DscModifierTableKey.MODIFIER, value);
        DscModifierTableInternal table = BinaryDescriptionProvider.getInstance().getDscModifierTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscModifierRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(HcpcsModifier hcpcsModifier) {
        String description = this.getLatestDescription(hcpcsModifier.getValue());
        hcpcsModifier.setDescription(description);
        return description;
    }
}

