/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscPafRowInternal;
import gov.cms.oce.dao.desc.table.DscPafTableInternal;
import gov.cms.oce.dao.dsc.DscPafDao;
import gov.cms.oce.model.internal.PaymentAdjustmentFlag;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscPafDaoImpl
implements DscPafDao {
    private static final Logger logger = LoggerFactory.getLogger(DscPafDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment adjustment flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscPafTableInternal.DscPafTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPafTableInternal.DscPafTableKey.class);
        key.put(DscPafTableInternal.DscPafTableKey.VALUE, value);
        DscPafTableInternal table = BinaryDescriptionProvider.getInstance().getDscPafTable();
        DscPafRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for payment adjustment flag \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(PaymentAdjustmentFlag paymentAdjustmentFlag, Short version) {
        String description = this.getDescription(String.valueOf(paymentAdjustmentFlag.getValue()), version);
        paymentAdjustmentFlag.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment adjustment flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscPafTableInternal.DscPafTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPafTableInternal.DscPafTableKey.class);
        key.put(DscPafTableInternal.DscPafTableKey.VALUE, value);
        DscPafTableInternal table = BinaryDescriptionProvider.getInstance().getDscPafTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscPafRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for payment adjustment flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(PaymentAdjustmentFlag paymentAdjustmentFlag) {
        String description = this.getLatestDescription(String.valueOf(paymentAdjustmentFlag.getValue()));
        paymentAdjustmentFlag.setDescription(description);
        return description;
    }
}

