/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscPkgRowInternal;
import gov.cms.oce.dao.desc.table.DscPkgTableInternal;
import gov.cms.oce.dao.dsc.DscPkgDao;
import gov.cms.oce.model.internal.PackagingFlag;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscPkgDaoImpl
implements DscPkgDao {
    private static final Logger logger = LoggerFactory.getLogger(DscPkgDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Packaging flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscPkgTableInternal.DscPkgTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPkgTableInternal.DscPkgTableKey.class);
        key.put(DscPkgTableInternal.DscPkgTableKey.VALUE, value);
        DscPkgTableInternal table = BinaryDescriptionProvider.getInstance().getDscPkgTable();
        DscPkgRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for packaging flag \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(PackagingFlag packagingFlag, Short version) {
        String description = this.getDescription(String.valueOf(packagingFlag.getValue()), version);
        packagingFlag.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Packaging flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscPkgTableInternal.DscPkgTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPkgTableInternal.DscPkgTableKey.class);
        key.put(DscPkgTableInternal.DscPkgTableKey.VALUE, value);
        DscPkgTableInternal table = BinaryDescriptionProvider.getInstance().getDscPkgTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscPkgRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for packaging flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(PackagingFlag packagingFlag) {
        String description = this.getLatestDescription(String.valueOf(packagingFlag.getValue()));
        packagingFlag.setDescription(description);
        return description;
    }
}

