/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscStatusIndicatorRowInternal;
import gov.cms.oce.dao.desc.table.DscStatusIndicatorTableInternal;
import gov.cms.oce.dao.dsc.DscStatusIndicatorDao;
import gov.cms.oce.model.internal.StatusIndicator;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscStatusIndicatorDaoImpl
implements DscStatusIndicatorDao {
    private static final Logger logger = LoggerFactory.getLogger(DscStatusIndicatorDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Status indicator parameter is null/empty.");
            }
            return "";
        }
        Map<DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey.class);
        key.put(DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey.STATUS_INDICATOR, value);
        DscStatusIndicatorTableInternal table = BinaryDescriptionProvider.getInstance().getDscStatusIndicatorTable();
        DscStatusIndicatorRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for status indicator \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(StatusIndicator statusIndicator, Short version) {
        String description = this.getDescription(statusIndicator.getValue(), version);
        statusIndicator.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Status indicator parameter is null/empty.");
            }
            return "";
        }
        Map<DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey.class);
        key.put(DscStatusIndicatorTableInternal.DscStatusIndicatorTableKey.STATUS_INDICATOR, value);
        DscStatusIndicatorTableInternal table = BinaryDescriptionProvider.getInstance().getDscStatusIndicatorTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscStatusIndicatorRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for status indicator \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(StatusIndicator statusIndicator) {
        String description = this.getLatestDescription(statusIndicator.getValue());
        statusIndicator.setDescription(description);
        return description;
    }
}

