/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.DataDiscountFormulaRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataDiscountFormulaTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(DataDiscountFormulaTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<DataDiscountFormulaRowInternal>> table;

    private DataDiscountFormulaTableInternal() {
        this(null);
    }

    public DataDiscountFormulaTableInternal(Map<String, List<DataDiscountFormulaRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<DataDiscountFormulaRowInternal> getRowInternal(Map<DataDiscountFormulaTableKey, String> tableKey) {
        List<DataDiscountFormulaRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final DataDiscountFormulaRowInternal getRowInternal(Map<DataDiscountFormulaTableKey, String> tableKey, short version) {
        for (DataDiscountFormulaRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum DataDiscountFormulaTableKey {
        DISCOUNT_KEY;

    }
}

