/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.EditBypass;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContractorOverride
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ContractorOverride.class);

    ContractorOverride() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        block10: for (LineItemInternal line : claim.getLineItemList().getValue()) {
            EditBypass bypass = line.getEditBypass();
            if (claim.isOpps() && line.matchesActionFlag(0) && line.isContractorEditBypassed()) {
                line.setPaymentApc(bypass.getApc().getValue());
                line.getPaymentApc().setDescription(bypass.getApc().getDescription());
                line.setStatusIndicator(bypass.getStatusIndicator().getValue());
                line.getStatusIndicator().setDescription(bypass.getStatusIndicator().getDescription());
                line.setPaymentIndicator(bypass.getPaymentIndicator().getValue());
                line.getPaymentIndicator().setDescription(bypass.getPaymentIndicator().getDescription());
                line.setDiscountingFormula(bypass.getDiscountingFormula().getValue());
                line.getDiscountingFormula().setDescription(bypass.getDiscountingFormula().getDescription());
                line.setRejectionDenialFlag(bypass.getRejectionDenialFlag().getValue());
                line.getRejectionDenialFlag().setDescription(bypass.getRejectionDenialFlag().getDescription());
                line.setPackagingFlag(bypass.getPackagingFlag().getValue());
                line.getPackagingFlag().setDescription(bypass.getPackagingFlag().getDescription());
                line.setPaymentAdjustmentFlag01(bypass.getPaymentAdjustmentFlag01().getValue());
                line.getPaymentAdjustmentFlag01().setDescription(bypass.getPaymentAdjustmentFlag01().getDescription());
                line.setPaymentAdjustmentFlag02(bypass.getPaymentAdjustmentFlag02().getValue());
                line.getPaymentAdjustmentFlag02().setDescription(bypass.getPaymentAdjustmentFlag02().getDescription());
            }
            if (!line.matchesActionFlag(0) || !line.getFlags().isSet(LineFlags.CONTRACTOR_OVERRIDE_PRESENT)) continue;
            boolean validEdit = false;
            for (EditValue e : bypass.getEditBypassList().getValue()) {
                if (e == EditValue.NO_EDIT) continue;
                validEdit = true;
                break;
            }
            if (!validEdit || !claim.isOpps() || !line.matchesActionFlag(0)) continue;
            line.setPaymentApc(bypass.getApc().getValue());
            line.getPaymentApc().setDescription(bypass.getApc().getDescription());
            line.setStatusIndicator(bypass.getStatusIndicator().getValue());
            line.getStatusIndicator().setDescription(bypass.getStatusIndicator().getDescription());
            line.setPaymentIndicator(bypass.getPaymentIndicator().getValue());
            line.getPaymentIndicator().setDescription(bypass.getPaymentIndicator().getDescription());
            line.setDiscountingFormula(bypass.getDiscountingFormula().getValue());
            line.getDiscountingFormula().setDescription(bypass.getDiscountingFormula().getDescription());
            line.setRejectionDenialFlag(bypass.getRejectionDenialFlag().getValue());
            line.getRejectionDenialFlag().setDescription(bypass.getRejectionDenialFlag().getDescription());
            line.setPackagingFlag(bypass.getPackagingFlag().getValue());
            line.getPackagingFlag().setDescription(bypass.getPackagingFlag().getDescription());
            line.setPaymentAdjustmentFlag01(bypass.getPaymentAdjustmentFlag01().getValue());
            line.getPaymentAdjustmentFlag01().setDescription(bypass.getPaymentAdjustmentFlag01().getDescription());
            line.setPaymentAdjustmentFlag02(bypass.getPaymentAdjustmentFlag02().getValue());
            line.getPaymentAdjustmentFlag02().setDescription(bypass.getPaymentAdjustmentFlag02().getDescription());
            String paymentMethodFlagValue = bypass.getPaymentMethodFlag().getValue();
            if (paymentMethodFlagValue == null) {
                line.setPaymentMethodFlag("Z");
                continue;
            }
            switch (paymentMethodFlagValue) {
                case "V": 
                case "W": 
                case "X": 
                case "Y": 
                case "Z": {
                    line.setPaymentMethodFlag(paymentMethodFlagValue);
                    continue block10;
                }
            }
            line.setPaymentMethodFlag("Z");
        }
        return false;
    }
}

