/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.model.rsc.PaymentAdjustmentFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitializePaymentAdjustmentFlag
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InitializePaymentAdjustmentFlag.class);

    InitializePaymentAdjustmentFlag() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (!navigator.isInitialized()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping logic block because required navigator isn't available");
            }
            return false;
        }
        ClaimDate midQuarterTerminationDate = this.getMidQuarterTerminationDate(claim);
        for (LineItemInternal line : navigator.getLineItemList()) {
            boolean adjustable = !line.isPackaged() || !line.isZeroCharge();
            FlagSet<LineFlags> flags = line.getFlags();
            if (line.isNotPackaged() && flags.isSet(LineFlags.DATA_HCPCS_FILM_XRAY) && line.isHcpcsModifierPresent("FX")) {
                if (flags.isSet(LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA)) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_COINS);
                } else {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_REDUCTION);
                }
            }
            if (line.isNotPackaged() && flags.isSet(LineFlags.DATA_HCPCS_FILM_XRAY) && line.isHcpcsModifierPresent("FY")) {
                if (flags.isSet(LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA)) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_COINS);
                } else {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_REDUCTION);
                }
            }
            if (adjustable && (claim.isConditionCodePresent("MA") || flags.isSet(LineFlags.DATA_HCPCS_DEDUCTIBLE_NA) && (midQuarterTerminationDate == null || flags.isNotSet(LineFlags.DATA_HCPCS_CMS_MID_QUARTER_TERMINATION_BYPASS) || !midQuarterTerminationDate.getValueAsDate().isBefore(line.getServiceDate().getValueAsDate())))) {
                flags.set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA);
            }
            if (adjustable && (flags.anySet(LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA) || line.isHcpcsModifierPresent("Q3") || OceClaimUtility.isCsModifierApplicable(line) && line.isHcpcsModifierPresent("CS") && claim.matchesBillType("13") && !claim.isConditionCodePresent("41") && (line.matchesStatusIndicator("V", "J2") || line.matchesStatusIndicator("S") && line.matchesHcpcs(HardcodedHcpcsSet.CRITICAL_CARE, HardcodedHcpcsSet.COVID_19_SPECIMEN_COLLECTION)) && (midQuarterTerminationDate == null || !midQuarterTerminationDate.getValueAsDate().isBefore(line.getServiceDate().getValueAsDate())))) {
                flags.set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_COINS_NA);
            }
            if (adjustable && flags.anySet((LineFlags)new LineFlags[]{LineFlags.DATA_HCPCS_COINS_NA, LineFlags.DATA_HCPCS_PASSTHROUGH_CONTRAST, LineFlags.DATA_HCPCS_PASSTHROUGH_RADIOPHARM, LineFlags.DATA_HCPCS_PASSTHROUGH_STRESS_AGENT, LineFlags.DATA_HCPCS_PASSTHROUGH_SKIN_PRODUCT})) {
                flags.set(LineFlags.PAYMENT_ADJUSTMENT_COINS_NA);
            }
            if (claim.isClaimVersionBefore(65)) {
                if (line.matchesStatusIndicator("G")) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_PASSTHRU_DRUG_OR_BIOLOGICAL);
                } else if (line.matchesStatusIndicator("H")) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_ADJUSTED_TO_COST);
                } else if (line.matchesStatusIndicator("J")) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_NEW_DRUG_OR_BIOLOGICAL);
                }
            }
            if (!claim.isClaimVersionAfter(82) || !claim.matchesBillType("13", "76") || !claim.isConditionCodePresent("M5") || !line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.isNotPackaged() || !line.getFlags().isSet(LineFlags.DATA_HCPCS_OPIOID_USE_DISORDER)) continue;
            flags.set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_COINS_NA);
        }
        for (Day day : navigator.getDayList()) {
            if (!day.isHcpcsModifierPresent("PT")) continue;
            boolean hasColorectal = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_COLORECTAL_SCREENING)) continue;
                hasColorectal = true;
                break;
            }
            if (!hasColorectal) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || line.isPackaged() && line.isZeroCharge() || line.getPaymentAdjustmentFlag01().getValue() != 0 && !line.getFlags().isSet(LineFlags.PAYMENT_ADJUSTMENT_UNITS_REDUCED_TO_ONE) || !line.matchesStatusIndicator("J1", "T")) continue;
                if (claim.isClaimVersionBefore(86)) {
                    line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA);
                    continue;
                }
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA_COINS_REDUCED);
            }
        }
        return false;
    }

    private ClaimDate getMidQuarterTerminationDate(OceClaimInternal claim) {
        for (ValueCode code : claim.getValueCodeInputList().getValue()) {
            if (!"Z9".equals(code.getCode())) continue;
            ClaimDate date = code.getValueAsDate();
            if (!date.isValid()) {
                date = claim.getDateStarted();
            }
            return date;
        }
        return null;
    }
}

