/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaymentMethodFqhcOverride
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(PaymentMethodFqhcOverride.class);

    PaymentMethodFqhcOverride() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        for (LineItemInternal line : claim.getLineItemList().getValue()) {
            if (!OceClaimUtility.isCsModifierApplicable(line) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_EMPTY_HCPCS) || !line.isHcpcsModifierPresent("CS")) continue;
            line.setPaymentMethodFlag("C");
        }
        return false;
    }
}

