/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedBillTypeSet;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateBillType
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ValidateBillType.class);

    ValidateBillType() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.getFlags().isSet(ClaimFlags.INPUT_INVALID_BILL_TYPE)) {
            claim.assignEdit(EditValue.INVALID_BILL_TYPE);
            claim.setReturnCode(ReturnCode.BAD_BILL_TYPE, ClaimProcessedValue.ONE);
            return true;
        }
        if (claim.isOpps() && HardcodedBillTypeSet.isOpps(claim.getBillType())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Type of bill \"{}\" recognized for OPPS processing.", (Object)claim.getBillType().getValue());
            }
        } else if (claim.isNonOpps() && HardcodedBillTypeSet.isNonOpps(claim.getBillType())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Type of bill \"{}\" recognized for Non-OPPS processing.", (Object)claim.getBillType().getValue());
            }
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("Type of bill \"{}\" applicable for neither OPPS nor Non-OPPS processing, aborting.", (Object)claim.getBillType().getValue());
            }
            claim.getFlags().set(ClaimFlags.INPUT_INVALID_BILL_TYPE);
            claim.assignEdit(EditValue.INVALID_BILL_TYPE);
            claim.setReturnCode(ReturnCode.BAD_BILL_TYPE, ClaimProcessedValue.ONE);
            return true;
        }
        return false;
    }
}

