/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapAddonSaaSDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddonSaaSLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(AddonSaaSLogic.class);

    AddonSaaSLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapAddonSaaSDao dao = processor.getResourceManager().getDataDaoFactory().getMapAddonSaaSDao();
        short version = claim.getVersionAsPrimitive();
        for (LineItemInternal addon : navigator.getLineItemList()) {
            if (!addon.getFlags().noneSet(LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !addon.getFlags().isSet(LineFlags.DATA_HCPCS_ADDON_SAAS)) continue;
            boolean matchFound = false;
            for (LineItemInternal primary : navigator.getLineItemList()) {
                if (addon == primary || !primary.getFlags().noneSet(LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || dao.getRow(addon, primary, (Short)version) == null) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            claim.assignEdit(EditValue.ADDON_TYPE_ONE_MISSING_PRIMARY, addon);
        }
        return false;
    }
}

