/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssignDefaultApcLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(AssignDefaultApcLogic.class);

    AssignDefaultApcLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) && !line.matchesActionFlag(4)) continue;
            String apc = line.getTableData().getDefaultApc().getValue();
            if (apc != null) {
                line.setHcpcsApc(apc);
                line.setPaymentApc(apc);
            }
            if (!line.matchesStatusIndicator("N") || !line.isNotPackaged()) continue;
            OceClaimUtility.packageLine(line);
        }
        return false;
    }
}

