/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.processing.AcquiredDrug340BLogic;
import gov.cms.oce.logic.processing.AddonCovidPairLogic;
import gov.cms.oce.logic.processing.AddonType1And3PairLogic;
import gov.cms.oce.logic.processing.AdvanceCarePlanningLogic;
import gov.cms.oce.logic.processing.AllogeneicTransplantLogic;
import gov.cms.oce.logic.processing.AssignDefaultApcLogic;
import gov.cms.oce.logic.processing.BilateralMultipleInherentLogic;
import gov.cms.oce.logic.processing.BilateralTerminatedLogic;
import gov.cms.oce.logic.processing.BilateralUnitsModifierConflictLogic;
import gov.cms.oce.logic.processing.BiosimilarBundledBiologicalLogic;
import gov.cms.oce.logic.processing.BiosimilarLogic;
import gov.cms.oce.logic.processing.BloodLogic;
import gov.cms.oce.logic.processing.BloodProductRevenueCodeConflictLogic;
import gov.cms.oce.logic.processing.BloodServiceMissingProductLogic;
import gov.cms.oce.logic.processing.ClaimAgeLogic;
import gov.cms.oce.logic.processing.ClaimSexLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForDenialLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForReviewLogic;
import gov.cms.oce.logic.processing.CompositeImagingLogic;
import gov.cms.oce.logic.processing.CompositeLdrLogic;
import gov.cms.oce.logic.processing.ComprehensiveApcComplexityAdjustmentLogic;
import gov.cms.oce.logic.processing.ComprehensiveApcPackagingLogic;
import gov.cms.oce.logic.processing.ComprehensiveApcPrimaryEvaluationLogic;
import gov.cms.oce.logic.processing.ComprehensiveObservationLogic;
import gov.cms.oce.logic.processing.ConditionCode41NotAllowedLogic;
import gov.cms.oce.logic.processing.ConditionalClaimLogic;
import gov.cms.oce.logic.processing.ConditionalDayLogic;
import gov.cms.oce.logic.processing.CorneaTransplantLogic;
import gov.cms.oce.logic.processing.CriticalCareClaimLogic;
import gov.cms.oce.logic.processing.CriticalCareDayLogic;
import gov.cms.oce.logic.processing.CsModifierLogic;
import gov.cms.oce.logic.processing.CsModifierMidQuarterTerminationLogic;
import gov.cms.oce.logic.processing.DiagnosisAgeLogic;
import gov.cms.oce.logic.processing.DiagnosisEcodeLogic;
import gov.cms.oce.logic.processing.DiagnosisInvalidLogic;
import gov.cms.oce.logic.processing.DiagnosisSexLogic;
import gov.cms.oce.logic.processing.DiagnosisUnacceptablePrincipalLogic;
import gov.cms.oce.logic.processing.DirectAdmissionRequiresObservationLogic;
import gov.cms.oce.logic.processing.DmeProcedureLogic;
import gov.cms.oce.logic.processing.DrugBiologicalMissingPayableServiceLogic;
import gov.cms.oce.logic.processing.EducationalOnlyLogic;
import gov.cms.oce.logic.processing.HcpcsAgeInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsMidQuarterTerminationLogic;
import gov.cms.oce.logic.processing.HcpcsModifierConflictLogic;
import gov.cms.oce.logic.processing.HcpcsModifierInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsModifierReportedPriorToApprovalLogic;
import gov.cms.oce.logic.processing.HcpcsSexLogic;
import gov.cms.oce.logic.processing.ImplantationDeviceInconsistencyLogic;
import gov.cms.oce.logic.processing.ImplantationDeviceProcedureMissingDevice;
import gov.cms.oce.logic.processing.IncidentalOnlyLogic;
import gov.cms.oce.logic.processing.IncorrectPTModifierReportingLogic;
import gov.cms.oce.logic.processing.InpatientComprehensiveLogic;
import gov.cms.oce.logic.processing.InpatientDayDeniedLogic;
import gov.cms.oce.logic.processing.InpatientTkaAnesthesiaLogic;
import gov.cms.oce.logic.processing.LabServiceOverride12x14xLogic;
import gov.cms.oce.logic.processing.LabServiceOverrideLogic;
import gov.cms.oce.logic.processing.ManualPricingLogic;
import gov.cms.oce.logic.processing.MentalHealthCompositeLogic;
import gov.cms.oce.logic.processing.MentalHealthPhpNotPayableOutsidePhpLogic;
import gov.cms.oce.logic.processing.NcciLogic;
import gov.cms.oce.logic.processing.NonBillableMacLogic;
import gov.cms.oce.logic.processing.NonCoveredHcpcsLogic;
import gov.cms.oce.logic.processing.NonCoveredRevenueCodeLogic;
import gov.cms.oce.logic.processing.NonStandardCtScanLogic;
import gov.cms.oce.logic.processing.NotPaidByMedicareLogic;
import gov.cms.oce.logic.processing.NotRecognizedByMedicareLogic;
import gov.cms.oce.logic.processing.NotRecognizedByOppsLogic;
import gov.cms.oce.logic.processing.NotSeparatelyPayableServiceLogic;
import gov.cms.oce.logic.processing.ObservationRevenueCodeLogic;
import gov.cms.oce.logic.processing.OffsetDevicePairLogic;
import gov.cms.oce.logic.processing.OffsetDrugBiologicialLogic;
import gov.cms.oce.logic.processing.OffsetRadiopharmaceuticalLogic;
import gov.cms.oce.logic.processing.OffsetTerminatedDeviceLogic;
import gov.cms.oce.logic.processing.OpioidTreatmentLogic;
import gov.cms.oce.logic.processing.OutpatientHospitalCodeOnlyLogic;
import gov.cms.oce.logic.processing.QuestionableLogic;
import gov.cms.oce.logic.processing.ReportedAfterNcdTerminationDateLogic;
import gov.cms.oce.logic.processing.ReportedOutsideCmsApprovalPeriodLogic;
import gov.cms.oce.logic.processing.ReportedPriorToFdaApprovalDateLogic;
import gov.cms.oce.logic.processing.ReportedPriorToInitialMarketingDate;
import gov.cms.oce.logic.processing.ReportedPriorToNdaApprovalDateLogic;
import gov.cms.oce.logic.processing.RevenueCodeInvalidLogic;
import gov.cms.oce.logic.processing.RevenueCodeNotRecognizedLogic;
import gov.cms.oce.logic.processing.RevenueCodeRequiresHcpcsLogic;
import gov.cms.oce.logic.processing.SameDayEandMSurgeryLogic;
import gov.cms.oce.logic.processing.SameDayMultipleMedicalVisitsLogic;
import gov.cms.oce.logic.processing.SeparateProcedureNotPaidLogic;
import gov.cms.oce.logic.processing.SkinSubstitute2Logic;
import gov.cms.oce.logic.processing.SometimesTherapyLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionHcpcsLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionRevenueCodeLogic;
import gov.cms.oce.logic.processing.TokenChargesDrugLogic;
import gov.cms.oce.logic.processing.TokenChargesEditLogic;
import gov.cms.oce.logic.processing.TokenChargesPackagingLogic;
import gov.cms.oce.logic.processing.TraumaResponseCodeRequiresRevenueCodeLogic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BillType12xLogicPath
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BillType12xLogicPath.class);

    BillType12xLogicPath() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        LogicProcessor logicProcessor = processor.getResourceManager().getLogicProcessor();
        LogicPhasePath logicPhasePath = logicProcessor.getLogicPhasePath(LogicPhase.PROCESSING);
        List<Logic> logicPath = logicPhasePath.getLogicPhasePath();
        OceClaimInternal claim = processor.getInternalClaim();
        logicPath.add(new ConditionCode41NotAllowedLogic());
        logicPath.add(new ClaimSubmittedForDenialLogic());
        if (claim.isOpps() && claim.isConditionCodePresent("W2")) {
            logicPath.add(new ComprehensiveApcPrimaryEvaluationLogic());
        }
        if (claim.isConditionCodePresent("W2")) {
            logicPath.add(new LabServiceOverrideLogic());
        } else {
            logicPath.add(new LabServiceOverride12x14xLogic());
        }
        logicPath.add(new NonStandardCtScanLogic());
        logicPath.add(new OutpatientHospitalCodeOnlyLogic());
        if (claim.isOpps()) {
            logicPath.add(new AssignDefaultApcLogic());
            if (claim.isClaimVersionAfter(69)) {
                logicPath.add(new InpatientTkaAnesthesiaLogic());
            }
            if (claim.isConditionCodePresent("W2")) {
                logicPath.add(new InpatientComprehensiveLogic());
            }
            logicPath.add(new InpatientDayDeniedLogic());
            logicPath.add(new EducationalOnlyLogic());
        }
        logicPath.add(new IncidentalOnlyLogic());
        if (claim.isClaimVersionAfter(77)) {
            logicPath.add(new OpioidTreatmentLogic());
            if (claim.isClaimVersionAfter(81)) {
                logicPath.add(new AddonCovidPairLogic());
            }
        }
        if (claim.isNonOpps() && claim.isClaimVersionAfter(70)) {
            logicPath.add(new AddonType1And3PairLogic());
        }
        if (claim.isOpps()) {
            logicPath.add(new SometimesTherapyLogic());
            logicPath.add(new AdvanceCarePlanningLogic());
        }
        if (OceClaimUtility.isCsModifierApplicable(claim)) {
            logicPath.add(new CsModifierLogic());
        }
        logicPath.add(new ClaimAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new ClaimSexLogic());
        }
        logicPath.add(new DiagnosisInvalidLogic());
        logicPath.add(new DiagnosisAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new DiagnosisSexLogic());
        }
        logicPath.add(new DiagnosisEcodeLogic());
        if (claim.isClaimVersionAfter(76)) {
            logicPath.add(new DiagnosisUnacceptablePrincipalLogic());
        }
        logicPath.add(new RevenueCodeInvalidLogic());
        if (claim.isOpps()) {
            logicPath.add(new ObservationRevenueCodeLogic());
        }
        logicPath.add(new RevenueCodeNotRecognizedLogic());
        logicPath.add(new BiosimilarLogic());
        logicPath.add(new BiosimilarBundledBiologicalLogic());
        logicPath.add(new ReportedPriorToInitialMarketingDate());
        if (!claim.isConditionCodePresent("41")) {
            logicPath.add(new HcpcsAgeInvalidLogic());
        }
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new HcpcsSexLogic());
        }
        logicPath.add(new ReportedOutsideCmsApprovalPeriodLogic());
        logicPath.add(new NonCoveredHcpcsLogic());
        logicPath.add(new QuestionableLogic());
        if (claim.isOpps()) {
            logicPath.add(new NotPaidByMedicareLogic());
        }
        logicPath.add(new NotRecognizedByMedicareLogic());
        if (claim.isOpps()) {
            logicPath.add(new NotRecognizedByOppsLogic());
        }
        logicPath.add(new StatutoryExclusionHcpcsLogic());
        logicPath.add(new ClaimSubmittedForReviewLogic());
        if (claim.isOpps()) {
            logicPath.add(new BloodServiceMissingProductLogic());
        }
        logicPath.add(new DrugBiologicalMissingPayableServiceLogic());
        if (claim.isOpps()) {
            logicPath.add(new RevenueCodeRequiresHcpcsLogic());
        }
        logicPath.add(new NonCoveredRevenueCodeLogic());
        logicPath.add(new StatutoryExclusionRevenueCodeLogic());
        logicPath.add(new HcpcsInvalidLogic());
        logicPath.add(new CorneaTransplantLogic());
        logicPath.add(new AllogeneicTransplantLogic());
        if (claim.isOpps()) {
            logicPath.add(new BloodProductRevenueCodeConflictLogic());
            logicPath.add(new BloodLogic());
        }
        logicPath.add(new HcpcsModifierInvalidLogic());
        logicPath.add(new HcpcsModifierReportedPriorToApprovalLogic());
        logicPath.add(new HcpcsModifierConflictLogic());
        if (claim.isOpps()) {
            logicPath.add(new BilateralTerminatedLogic());
            logicPath.add(new BilateralUnitsModifierConflictLogic());
        }
        logicPath.add(new NcciLogic());
        if (claim.isClaimVersionAfter(87) && !claim.isConditionCodePresent("41")) {
            logicPath.add(new CsModifierMidQuarterTerminationLogic());
            logicPath.add(new HcpcsMidQuarterTerminationLogic());
        }
        if (claim.isOpps()) {
            logicPath.add(new IncorrectPTModifierReportingLogic());
        }
        if (claim.isOpps() && claim.isClaimVersionAfter(86)) {
            logicPath.add(new AcquiredDrug340BLogic());
        }
        if (claim.isOpps()) {
            logicPath.add(new ManualPricingLogic());
        }
        logicPath.add(new ReportedPriorToFdaApprovalDateLogic());
        logicPath.add(new ReportedPriorToNdaApprovalDateLogic());
        logicPath.add(new ReportedAfterNcdTerminationDateLogic());
        if (claim.isOpps()) {
            logicPath.add(new TraumaResponseCodeRequiresRevenueCodeLogic());
        }
        logicPath.add(new MentalHealthPhpNotPayableOutsidePhpLogic());
        logicPath.add(new MentalHealthCompositeLogic());
        if (claim.isOpps()) {
            if (claim.isClaimVersionBefore(66)) {
                logicPath.add(new ConditionalDayLogic());
                logicPath.add(new CriticalCareDayLogic());
            } else {
                logicPath.add(new ConditionalClaimLogic());
                logicPath.add(new CriticalCareClaimLogic());
            }
            if (claim.isClaimVersionBefore(70)) {
                logicPath.add(new CompositeLdrLogic());
            }
            logicPath.add(new CompositeImagingLogic());
            if (claim.isConditionCodePresent("W2")) {
                logicPath.add(new ComprehensiveApcPrimaryEvaluationLogic());
            }
        }
        logicPath.add(new DmeProcedureLogic());
        logicPath.add(new NonBillableMacLogic());
        if (claim.isOpps()) {
            if (claim.isConditionCodePresent("W2")) {
                logicPath.add(new ComprehensiveObservationLogic());
            }
            logicPath.add(new DirectAdmissionRequiresObservationLogic());
            logicPath.add(new ImplantationDeviceInconsistencyLogic());
            logicPath.add(new ImplantationDeviceProcedureMissingDevice());
            logicPath.add(new TokenChargesEditLogic());
            logicPath.add(new SeparateProcedureNotPaidLogic());
            logicPath.add(new SkinSubstitute2Logic());
        }
        logicPath.add(new BilateralMultipleInherentLogic());
        if (claim.isOpps()) {
            if (claim.isConditionCodePresent("W2")) {
                logicPath.add(new ComprehensiveApcComplexityAdjustmentLogic());
                logicPath.add(new ComprehensiveApcPackagingLogic());
            }
            logicPath.add(new SameDayEandMSurgeryLogic());
            if (!claim.isConditionCodePresent("G0")) {
                logicPath.add(new SameDayMultipleMedicalVisitsLogic());
            }
            logicPath.add(new TokenChargesPackagingLogic());
            if (claim.isClaimVersionAfter(83)) {
                logicPath.add(new TokenChargesDrugLogic());
            }
            logicPath.add(new OffsetDevicePairLogic());
            logicPath.add(new OffsetTerminatedDeviceLogic());
            logicPath.add(new OffsetRadiopharmaceuticalLogic());
            logicPath.add(new OffsetDrugBiologicialLogic());
            logicPath.add(new NotSeparatelyPayableServiceLogic());
        }
        return false;
    }
}

