/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConditionalDayLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalDayLogic.class);

    ConditionalDayLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        Navigator navigator = processor.getResourceManager().getNavigator();
        LineItemInternal highestPayingLine = null;
        LineItemInternal highestPayingLineT = null;
        boolean q1CodePresent = false;
        boolean q2CodePresent = false;
        boolean payableTPresent = false;
        boolean payableSTVPresent = false;
        for (Day day : navigator.getDayList()) {
            highestPayingLine = null;
            highestPayingLineT = null;
            q1CodePresent = false;
            q2CodePresent = false;
            payableTPresent = false;
            payableSTVPresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                String statusIndicator;
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed()) continue;
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_STV_PACKAGED)) {
                    if (q1CodePresent) continue;
                    q1CodePresent = true;
                    continue;
                }
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_T_PACKAGED)) {
                    if (q2CodePresent) continue;
                    q2CodePresent = true;
                    continue;
                }
                switch (statusIndicator = line.matchesStatusIndicator("Q1", "Q2", "Q3") ? line.getTableData().getApcStatusIndicator().getValue() : line.getStatusIndicator().getValue()) {
                    case "T": {
                        if (!payableTPresent) {
                            payableTPresent = true;
                        }
                    }
                    case "S": 
                    case "V": {
                        if (payableSTVPresent) break;
                        payableSTVPresent = true;
                        break;
                    }
                }
            }
            if (q1CodePresent) {
                if (payableSTVPresent) {
                    for (LineItemInternal line : day.getLineItemList()) {
                        if (!line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed() || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_STV_PACKAGED) || !line.isNotSeparatelyPayable()) continue;
                        OceClaimUtility.packageLine(line);
                        line.getFlags().set(LineFlags.COMPOSITE_LINE);
                    }
                } else {
                    for (LineItemInternal line : day.getLineItemList()) {
                        if (!line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed() || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_STV_PACKAGED) || !line.isNotSeparatelyPayable()) continue;
                        if (highestPayingLine == null) {
                            highestPayingLine = line;
                            continue;
                        }
                        if (highestPayingLine.getTableData().getApcPayment() < line.getTableData().getApcPayment()) {
                            OceClaimUtility.packageLine(highestPayingLine);
                            highestPayingLine.getFlags().set(LineFlags.COMPOSITE_LINE);
                            highestPayingLine = line;
                            continue;
                        }
                        OceClaimUtility.packageLine(line);
                        line.getFlags().set(LineFlags.COMPOSITE_LINE);
                    }
                }
            }
            if (q2CodePresent) {
                if (payableTPresent) {
                    for (LineItemInternal line : day.getLineItemList()) {
                        if (!line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed() || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_T_PACKAGED) || !line.isNotSeparatelyPayable() || !line.matchesStatusIndicator("Q2")) continue;
                        OceClaimUtility.packageLine(line);
                        line.getFlags().set(LineFlags.COMPOSITE_LINE);
                    }
                } else {
                    for (LineItemInternal line : day.getLineItemList()) {
                        if (!line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed() || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_T_PACKAGED) || !line.isNotSeparatelyPayable() || !line.matchesStatusIndicator("Q2")) continue;
                        if (highestPayingLineT == null) {
                            highestPayingLineT = line;
                            continue;
                        }
                        if (highestPayingLineT.getTableData().getApcPayment() < line.getTableData().getApcPayment()) {
                            OceClaimUtility.packageLine(highestPayingLineT);
                            highestPayingLineT.getFlags().set(LineFlags.COMPOSITE_LINE);
                            highestPayingLineT = line;
                            continue;
                        }
                        OceClaimUtility.packageLine(line);
                        line.getFlags().set(LineFlags.COMPOSITE_LINE);
                    }
                }
            }
            if (highestPayingLine != null) {
                if (highestPayingLineT != null) {
                    if (highestPayingLine.getTableData().getApcPayment() < highestPayingLineT.getTableData().getApcPayment()) {
                        OceClaimUtility.packageLine(highestPayingLine);
                        highestPayingLine.getFlags().set(LineFlags.COMPOSITE_LINE);
                        OceClaimUtility.assignConditionalApc(highestPayingLineT);
                        OceClaimUtility.reduceUnits(highestPayingLineT);
                        continue;
                    }
                    OceClaimUtility.packageLine(highestPayingLineT);
                    highestPayingLineT.getFlags().set(LineFlags.COMPOSITE_LINE);
                    OceClaimUtility.assignConditionalApc(highestPayingLine);
                    OceClaimUtility.reduceUnits(highestPayingLine);
                    continue;
                }
                OceClaimUtility.assignConditionalApc(highestPayingLine);
                OceClaimUtility.reduceUnits(highestPayingLine);
                continue;
            }
            if (highestPayingLineT == null) continue;
            OceClaimUtility.assignConditionalApc(highestPayingLineT);
            OceClaimUtility.reduceUnits(highestPayingLineT);
        }
        return false;
    }
}

