/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.DiagnosisFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosisInvalidLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisInvalidLogic.class);

    DiagnosisInvalidLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.getPrincipalDiagnosisCode().getValue() == null || claim.getPrincipalDiagnosisCode().getFlags().isSet(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS) && claim.getPrincipalDiagnosisCode().getFlags().isNotSet(DiagnosisFlags.DIAGNOSIS_VALID_IN_FUTURE_VERSION)) {
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS, claim.getPrincipalDiagnosisCode());
        }
        for (DiagnosisCode diagnosisCode : claim.getReasonForVisitDiagnosisCodeList().getValue()) {
            if (!diagnosisCode.getFlags().isSet(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS) || !diagnosisCode.getFlags().isNotSet(DiagnosisFlags.DIAGNOSIS_VALID_IN_FUTURE_VERSION)) continue;
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS, diagnosisCode);
        }
        for (DiagnosisCode diagnosisCode : claim.getSecondaryDiagnosisCodeList().getValue()) {
            if (!diagnosisCode.getFlags().isSet(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS) || !diagnosisCode.getFlags().isNotSet(DiagnosisFlags.DIAGNOSIS_VALID_IN_FUTURE_VERSION)) continue;
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS, diagnosisCode);
        }
        return false;
    }
}

