/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrugBiologicalMissingPayableServiceLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(DrugBiologicalMissingPayableServiceLogic.class);

    DrugBiologicalMissingPayableServiceLogic() {
    }

    private final boolean isPayableOnClaim(OceClaimInternal claim) {
        if (claim.isOpps()) {
            for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.matchesStatusIndicator("J1", "J2", "P", "Q1", "Q2", "Q3", "R", "S", "T", "U", "V")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!this.isPayableOnClaim(claim)) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.DATA_HCPCS_BYPASS_E99) || !line.matchesStatusIndicator("G", "K") || line.isEditPresent(EditValue.INFORMATION_ONLY_CODE_PRESENT)) continue;
                claim.assignEdit(EditValue.PASSTHROUGH_DRUG_MISSING_PROCEDURE, line);
            }
        }
        return false;
    }
}

