/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HcpcsAgeLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(HcpcsAgeLogic.class);

    HcpcsAgeLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.getFlags().isNotSet(ClaimFlags.INPUT_INVALID_SEX)) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS)) continue;
                int tableDataLowAgeValue = line.getTableData().getLowAge().getValue().intValue();
                int tableDataHighAgeValue = line.getTableData().getHighAge().getValue().intValue();
                int patientAge = claim.getAge().getValue().intValue();
                if (patientAge >= tableDataLowAgeValue && tableDataHighAgeValue >= patientAge) continue;
                claim.assignEdit(EditValue.INVALID_HCPCS_AGE, line);
            }
        }
        return false;
    }
}

