/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.DataHcpcsDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import java.time.LocalDate;
import java.time.Month;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HcpcsInvalidLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(HcpcsInvalidLogic.class);

    HcpcsInvalidLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        LocalDate dateEnded;
        int monthEnded;
        LocalDate dateStarted;
        int monthStarted;
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean alternateVersionApplicable = false;
        if (claim.matchesBillType("32") && (monthStarted = (dateStarted = claim.getDateStarted().getValueAsDate()).getMonth().getValue()) > 10 && (monthEnded = (dateEnded = claim.getDateEnded().getValueAsDate()).getMonth().getValue()) < 3) {
            alternateVersionApplicable = true;
            DataHcpcsDao dao = processor.getResourceManager().getDataDaoFactory().getDataHcpcsDao();
            short nextVersion = (short)(claim.getVersionAsPrimitive() + 1);
            for (LineItemInternal line : navigator.getLineItemList()) {
                LocalDate dateOfService;
                if (!line.getFlags().isSet(LineFlags.INPUT_INVALID_HCPCS) || !line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || HardcodedRevenueCodeSet.isHippsCode(line.getRevenueCode()) || (dateOfService = line.getServiceDate().getValueAsDate()).getMonth() != Month.NOVEMBER && dateOfService.getMonth() != Month.DECEMBER && dao.getRow(line.getHcpcs(), (Short)nextVersion) != null) continue;
                claim.assignEdit(EditValue.INVALID_HCPCS, line);
            }
        }
        if (!alternateVersionApplicable) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.INPUT_INVALID_HCPCS) || !line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || HardcodedRevenueCodeSet.isHippsCode(line.getRevenueCode()) && claim.matchesBillType("32")) continue;
                claim.assignEdit(EditValue.INVALID_HCPCS, line);
            }
        }
        return false;
    }
}

