/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HcpcsMidQuarterTerminationLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(HcpcsMidQuarterTerminationLogic.class);

    HcpcsMidQuarterTerminationLogic() {
    }

    @Override
    public boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        ClaimDate midQuarterTerminationDate = this.getMidQuarterTerminationDate(claim);
        if (midQuarterTerminationDate == null) {
            return false;
        }
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_CMS_MID_QUARTER_TERMINATION) || !midQuarterTerminationDate.getValueAsDate().isBefore(line.getServiceDate().getValueAsDate()) || !line.getFlags().isNotSet(LineFlags.INPUT_LINE_EDIT_BYPASS)) continue;
            claim.assignEdit(EditValue.HCPCS_MID_QUARTER_TERMINATION, line);
        }
        return false;
    }

    private ClaimDate getMidQuarterTerminationDate(OceClaimInternal claim) {
        for (ValueCode code : claim.getValueCodeInputList().getValue()) {
            if (!"Z9".equals(code.getCode())) continue;
            ClaimDate date = code.getValueAsDate();
            if (!date.isValid()) {
                date = claim.getDateStarted();
            }
            return date;
        }
        return null;
    }
}

