/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncorrectPTModifierReportingLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(IncorrectPTModifierReportingLogic.class);

    @Override
    public boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            if (!day.isHcpcsModifierPresent("PT")) continue;
            boolean hasColorectal = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_COLORECTAL_SCREENING)) continue;
                hasColorectal = true;
                break;
            }
            if (hasColorectal) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_LINE_EDIT_BYPASS) || !line.isHcpcsModifierPresent("PT")) continue;
                claim.assignEdit(EditValue.INCORRECT_PT_MODIFIER, line);
            }
        }
        return false;
    }
}

