/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonBillableMacLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(NonBillableMacLogic.class);

    NonBillableMacLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean billType71 = claim.isClaimVersionAfter(70) && claim.matchesBillType("71");
        boolean billType77 = claim.isClaimVersionAfter(70) && claim.matchesBillType("77");
        boolean billType8182 = claim.matchesBillType("81", "82");
        boolean billType85 = claim.matchesBillType("85");
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_NON_BILLABLE_MAC) || (billType71 || billType77) && line.getFlags().isSet(LineFlags.DATA_HCPCS_BYPASS_E72_FQHC_RHC)) continue;
            if (billType8182 && HardcodedRevenueCodeSet.isPhysicianService(line.getRevenueCode())) {
                OceClaimUtility.setSeparatelyPayable(line);
                continue;
            }
            if (billType85 && HardcodedRevenueCodeSet.isProfessionalService(line.getRevenueCode())) continue;
            claim.assignEdit(EditValue.SERVICE_NOT_BILLABLE_TO_MAC, line);
        }
        return false;
    }
}

