/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotSeparatelyPayableServiceLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(NotSeparatelyPayableServiceLogic.class);

    NotSeparatelyPayableServiceLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean statusIndicatorQPresent = false;
        int deniedRejectedIgnoredLineCount = 0;
        int packagedLineCount = 0;
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (line.getFlags().isSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || line.isEditPresent(EditValue.INVALID_HCPCS) || line.isRejectedDeniedAndNotBypassed()) {
                ++deniedRejectedIgnoredLineCount;
                continue;
            }
            if (!line.matchesStatusIndicator("N")) continue;
            ++packagedLineCount;
            if (!line.matchesInitialStatusIndicatorQ()) continue;
            statusIndicatorQPresent = true;
        }
        int linesProcessed = navigator.getLineItemList().size();
        if (linesProcessed == packagedLineCount + deniedRejectedIgnoredLineCount && (0 < deniedRejectedIgnoredLineCount || 0 < packagedLineCount) || linesProcessed == packagedLineCount && statusIndicatorQPresent) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.matchesStatusIndicator("N") || line.isRejectionDenialEditPresent() || !line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                claim.assignEdit(EditValue.NO_PAYABLE_LINES, line);
            }
        }
        return false;
    }
}

