/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.OffsetApcDao;
import gov.cms.oce.dao.data.row.OffsetApcRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OffsetGroups;
import gov.cms.oce.model.rsc.ValueCodeValue;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import gov.cms.oce.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetRadiopharmaceuticalLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(OffsetRadiopharmaceuticalLogic.class);
    private static final OffsetGroups.OffsetApcGroupId RADIO_PHARM = OffsetGroups.OffsetApcGroupId.RADIO_PHARM;
    private static final OffsetGroups.OffsetApcListId[] OFFSET_APC_LIST_ID = new OffsetGroups.OffsetApcListId[]{OffsetGroups.OffsetApcListId.PT_RADIO_PHARM};

    OffsetRadiopharmaceuticalLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        OffsetApcDao offsetApcDao = processor.getResourceManager().getDataDaoFactory().getOffsetApcDao();
        short version = claim.getVersionAsPrimitive();
        ArrayList<LineItemInternal> radioPhamaceuticalList = null;
        ArrayList<ApcOffsetGroup> apcOffsetGroupList = null;
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
            if (line.getFlags().anySet(LineFlags.DATA_HCPCS_PASSTHROUGH_RADIOPHARM)) {
                if (radioPhamaceuticalList == null) {
                    radioPhamaceuticalList = new ArrayList<LineItemInternal>(6);
                }
                radioPhamaceuticalList.add(line);
                continue;
            }
            String apcValue = line.getPaymentApc().getValue();
            if (line.matchesApc(HardcodedApcSet.APC_ZERO)) {
                apcValue = line.getHcpcsApc().getValue();
            }
            if (apcValue.equals(HardcodedApcSet.APC_ZERO.getApc())) continue;
            if (apcOffsetGroupList == null) {
                OffsetApcRowInternal row = offsetApcDao.getRow(RADIO_PHARM, OFFSET_APC_LIST_ID, apcValue, (Short)version);
                if (row == null) continue;
                apcOffsetGroupList = new ArrayList<ApcOffsetGroup>();
                apcOffsetGroupList.add(new ApcOffsetGroup(apcValue, row.getAmount(), line.getUnitsAsPrimitive()));
                continue;
            }
            ApcOffsetGroup existingGroup = null;
            for (ApcOffsetGroup apcOffsetGroup : apcOffsetGroupList) {
                if (!apcOffsetGroup.apc.equals(apcValue)) continue;
                existingGroup = apcOffsetGroup;
                break;
            }
            if (existingGroup == null) {
                int i;
                ApcOffsetGroup apcOffsetGroup;
                OffsetApcRowInternal row = offsetApcDao.getRow(RADIO_PHARM, OFFSET_APC_LIST_ID, apcValue, (Short)version);
                if (row == null) continue;
                apcOffsetGroup = new ApcOffsetGroup(apcValue, row.getAmount(), line.getUnitsAsPrimitive());
                for (i = 0; i < apcOffsetGroupList.size() && ((ApcOffsetGroup)apcOffsetGroupList.get(i)).amount >= apcOffsetGroup.amount; ++i) {
                }
                apcOffsetGroupList.add(i, apcOffsetGroup);
                continue;
            }
            Iterator iterator = existingGroup;
            ((ApcOffsetGroup)iterator).units = ((ApcOffsetGroup)iterator).units + line.getUnitsAsPrimitive();
        }
        if (radioPhamaceuticalList == null || apcOffsetGroupList == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("No pass-through radiopharmaceuticals procedures found on claim.");
            }
        } else {
            ApcOffsetGroupClaim apcOffsetGroupDay = new ApcOffsetGroupClaim(apcOffsetGroupList, radioPhamaceuticalList);
            apcOffsetGroupDay.consume(claim, ValueCodeValue.QR, LineFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_1ST);
        }
        return false;
    }

    private final class ApcOffsetGroupClaim {
        private final List<LineItemInternal> radioPhamaceuticalList;
        private final List<ApcOffsetGroup> apcOffsetGroupList;

        private ApcOffsetGroupClaim(List<ApcOffsetGroup> apcOffsetGroupList, List<LineItemInternal> radioPhamaceuticalList) {
            this.apcOffsetGroupList = apcOffsetGroupList == null ? Collections.emptyList() : apcOffsetGroupList;
            this.radioPhamaceuticalList = radioPhamaceuticalList == null ? Collections.emptyList() : radioPhamaceuticalList;
        }

        private final int getCount() {
            int drugBiologicalCount = this.radioPhamaceuticalList.size();
            int apcOffsetCount = 0;
            for (ApcOffsetGroup apcOffsetGroup : this.apcOffsetGroupList) {
                apcOffsetCount += apcOffsetGroup.units;
            }
            return drugBiologicalCount < apcOffsetCount ? drugBiologicalCount : apcOffsetCount;
        }

        private final int getAmount(int count) {
            int amount = 0;
            for (ApcOffsetGroup apcOffsetGroup : this.apcOffsetGroupList) {
                if (count < apcOffsetGroup.units) {
                    amount += apcOffsetGroup.amount * count;
                    count = 0;
                } else {
                    amount += apcOffsetGroup.amount * apcOffsetGroup.units;
                    count -= apcOffsetGroup.units;
                }
                if (count >= 1) continue;
                break;
            }
            return amount;
        }

        private final void consume(OceClaimInternal claim, ValueCodeValue valueCodeValue, LineFlags flag) {
            int count = this.getCount();
            StringBuilder amountString = new StringBuilder().append(this.getAmount(count));
            StringUtilities.pad(amountString, 9, '0');
            claim.getValueCodeOutputList().setValue(valueCodeValue.position, valueCodeValue.code, amountString.toString());
            for (LineItemInternal radioPhamaceutical : this.radioPhamaceuticalList) {
                radioPhamaceutical.getFlags().set((LineFlags)new LineFlags[]{flag, LineFlags.RADIO_PHARMACEUTICAL_CONSUMED});
                if (--count >= 1) continue;
                break;
            }
        }
    }

    private final class ApcOffsetGroup {
        private final String apc;
        private final int amount;
        private int units;

        private ApcOffsetGroup(String apc, int amount, int units) {
            this.apc = apc;
            this.amount = amount;
            this.units = units;
        }
    }
}

