/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.OffsetApcDao;
import gov.cms.oce.dao.data.OffsetHcpcsDao;
import gov.cms.oce.dao.data.row.OffsetApcRowInternal;
import gov.cms.oce.dao.data.row.OffsetHcpcsRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OffsetGroups;
import gov.cms.oce.model.rsc.ValueCodeValue;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import gov.cms.oce.util.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetTerminatedDeviceLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(OffsetTerminatedDeviceLogic.class);

    OffsetTerminatedDeviceLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        StringBuilder amount;
        OceClaimInternal claim = processor.getInternalClaim();
        short version = claim.getVersionAsPrimitive();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean creditPresent = claim.isConditionCodePresent("49", "50", "53");
        boolean foundOffset = false;
        boolean foundCredit = false;
        int offsetTotalAmount = 0;
        int creditTotalAmount = 0;
        if (claim.isClaimVersionAfter(65)) {
            OffsetHcpcsDao offsetHcpcsDao = processor.getResourceManager().getDataDaoFactory().getOffsetHcpcsDao();
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.isNotPackaged() || !line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_TERMINATED_DEVICE_PROCEDURE)) continue;
                OffsetHcpcsRowInternal offsetHcpcsRow = offsetHcpcsDao.getRow(OffsetGroups.OffsetHcpcsListId.TERMINATED.getIndex(), line.getHcpcs().getValue(), version);
                if (offsetHcpcsRow == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("No row found for terminated CPT/HCPCS {} on {}, line {}", line.getHcpcs().getValue(), line.getDay().getIndex(), line.getDay().getLineIndex(line));
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Terminated {} CPT/HCPCS {} found amount {} given list id {}", line.isHcpcsModifierPresent("73") ? "offset" : "credit", line.getHcpcs().getValue(), offsetHcpcsRow.getAmount(), OffsetGroups.OffsetHcpcsListId.TERMINATED.getIndex());
                }
                if (line.isHcpcsModifierPresent("73")) {
                    offsetTotalAmount += offsetHcpcsRow.getAmount();
                    line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_TERMINATED);
                    if (foundOffset) continue;
                    foundOffset = true;
                    continue;
                }
                if (!creditPresent) continue;
                creditTotalAmount += offsetHcpcsRow.getAmount();
                line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_CREDIT_TERMINATED);
                if (foundCredit) continue;
                foundCredit = true;
            }
        } else {
            OffsetApcDao offsetApcDao = processor.getResourceManager().getDataDaoFactory().getOffsetApcDao();
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.isNotPackaged() || !line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_TERMINATED_DEVICE_PROCEDURE)) continue;
                OffsetApcRowInternal offsetApcRow = offsetApcDao.getRow(OffsetGroups.OffsetApcGroupId.TERMINATED.getIndex(), OffsetGroups.OffsetApcListId.TERMINATED.getIndex(), line.getPaymentApc().getValue(), (Short)version);
                if (offsetApcRow == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("No row found for terminated APC {} on {}, line {}", line.getPaymentApc().getValue(), line.getDay().getIndex(), line.getDay().getLineIndex(line));
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Terminated {} CPT/HCPCS {} found amount {} given group id {} and list id {}", line.isHcpcsModifierPresent("73") ? "offset" : "credit", line.getPaymentApc().getValue(), offsetApcRow.getAmount(), OffsetGroups.OffsetApcGroupId.TERMINATED.getIndex(), OffsetGroups.OffsetApcListId.TERMINATED.getIndex());
                }
                if (line.isHcpcsModifierPresent("73")) {
                    offsetTotalAmount += offsetApcRow.getAmount();
                    line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_TERMINATED);
                    if (foundOffset) continue;
                    foundOffset = true;
                    continue;
                }
                if (!creditPresent) continue;
                creditTotalAmount += offsetApcRow.getAmount();
                line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_CREDIT_TERMINATED);
                if (foundCredit) continue;
                foundCredit = true;
            }
        }
        if (foundOffset && !claim.getValueCodeOutputList().isValueCodeSet(ValueCodeValue.QQ.position)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Assigning total offset amount {} to value code {}", (Object)offsetTotalAmount, (Object)ValueCodeValue.QQ.code);
            }
            amount = new StringBuilder().append(offsetTotalAmount);
            StringUtilities.pad(amount, 9, '0');
            claim.getValueCodeOutputList().setValue(ValueCodeValue.QQ.position, ValueCodeValue.QQ.code, amount.toString());
        }
        if (foundCredit && !claim.getValueCodeOutputList().isValueCodeSet(ValueCodeValue.QU.position)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Assigning total credit amount {} to value code {}", (Object)creditTotalAmount, (Object)ValueCodeValue.QU.code);
            }
            amount = new StringBuilder().append(creditTotalAmount);
            StringUtilities.pad(amount, 9, '0');
            claim.getValueCodeOutputList().setValue(ValueCodeValue.QU.position, ValueCodeValue.QU.code, amount.toString());
        }
        return false;
    }
}

