/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.model.rsc.ValueCodeValue;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.DaySpan;
import gov.cms.oce.util.Navigator;
import gov.cms.oce.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartialHospitalizationServiceHours2Logic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(PartialHospitalizationServiceHours2Logic.class);
    private static final int DAYS_PER_SPAN = 7;
    private static final String DEFAULT_VALUE_CODE_FIELD = "000000000";

    PartialHospitalizationServiceHours2Logic() {
    }

    private final HourlyServiceCount getValueCodeInput(OceClaimInternal claim) {
        HourlyServiceCount hourlyServiceCount = null;
        ValueCode valueCode = claim.getValueCodeInput("QA");
        if (valueCode == null) {
            hourlyServiceCount = new HourlyServiceCount(DEFAULT_VALUE_CODE_FIELD);
            hourlyServiceCount.emptyValueCode = true;
        } else {
            String dateString = StringUtilities.toNonNullString(valueCode.getValue());
            String paddedDateString = StringUtilities.padLeft(dateString, 9, '0');
            try {
                hourlyServiceCount = new HourlyServiceCount(paddedDateString);
                String emptyValueCode = paddedDateString.substring(5);
                if ("0000".equals(emptyValueCode) || "    ".equals(emptyValueCode)) {
                    hourlyServiceCount.emptyValueCode = true;
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Value code QA date string \"{}\" is invalid. Aborting.", (Object)dateString);
            }
        }
        return hourlyServiceCount;
    }

    private final List<PartialHospitalizationDaySpan> getPartialHospitalizationDaySpanList(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        HourlyServiceCount inputValueCode = this.getValueCodeInput(claim);
        if (inputValueCode == null) {
            claim.setReturnCode(ReturnCode.INVALID_VALUE_CODE_INPUT, ClaimProcessedValue.FOUR);
            return null;
        }
        Navigator navigator = processor.getResourceManager().getNavigator();
        List<DaySpan> daySpanList = navigator.getDaySpanList(7, inputValueCode.days);
        ArrayList<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = new ArrayList<PartialHospitalizationDaySpan>();
        PartialHospitalizationDaySpan previousPhDaySpan = null;
        for (DaySpan daySpan : daySpanList) {
            PartialHospitalizationDaySpan phDaySpan = new PartialHospitalizationDaySpan(daySpan);
            phDaySpan.calculateTotalHours();
            if (daySpan.getIndex() == 0) {
                phDaySpan.firstSpan = true;
                phDaySpan.hourlyServiceCount.emptyValueCode = inputValueCode.emptyValueCode;
                HourlyServiceCount hourlyServiceCount = phDaySpan.hourlyServiceCount;
                hourlyServiceCount.days = hourlyServiceCount.days + inputValueCode.days;
                hourlyServiceCount = phDaySpan.hourlyServiceCount;
                hourlyServiceCount.hours = hourlyServiceCount.hours + inputValueCode.hours;
                hourlyServiceCount = phDaySpan.hourlyServiceCount;
                hourlyServiceCount.fractionalHour = hourlyServiceCount.fractionalHour + inputValueCode.fractionalHour;
            }
            if (daySpan.getIndex() == daySpanList.size() - 1) {
                phDaySpan.lastSpan = true;
            }
            if (phDaySpan.hourlyServiceCount.days == 7) {
                if (previousPhDaySpan != null && previousPhDaySpan.lastSpanOfCompleteDays) {
                    previousPhDaySpan.lastSpanOfCompleteDays = false;
                }
                phDaySpan.lastSpanOfCompleteDays = true;
            }
            previousPhDaySpan = phDaySpan;
            partialHospitalizationDaySpanList.add(phDaySpan);
        }
        return partialHospitalizationDaySpanList;
    }

    private final void assignEdits(OceClaimInternal claim, PartialHospitalizationDaySpan phDaySpan) {
        for (Day day : phDaySpan.daySpan.getList()) {
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.DATA_HCPCS_PH_ADDON)) continue;
                boolean changeRejectionDenialFlag = false;
                if (line.getRejectionDenialFlag().getValue() == null || line.getRejectionDenialFlag().getValue().intValue() == 0) {
                    changeRejectionDenialFlag = true;
                }
                claim.assignEdit(EditValue.PARTIAL_HOSPITALIZATION_SERVICE_COUNT_NOT_MET, line);
                if (!changeRejectionDenialFlag) continue;
                line.setRejectionDenialFlag((byte)3);
            }
        }
    }

    private final boolean applyAdmissionToDischargeImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        if (partialHospitalizationDaySpanList == null) {
            return true;
        }
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (!phDaySpan.isHourlyThresholdNotMet()) continue;
            boolean applyEdit = true;
            if (phDaySpan.firstSpan) {
                if (!claim.isConditionCodePresent("MP")) {
                    claim.getConditionCodeOutputList().addValue("MP");
                }
                applyEdit = false;
            }
            if (phDaySpan.lastSpanOfCompleteDays) {
                if (!claim.isConditionCodePresent("MQ")) {
                    claim.getConditionCodeOutputList().addValue("MQ");
                }
                applyEdit = false;
            }
            if (phDaySpan.lastSpan) {
                applyEdit = false;
            }
            if (!applyEdit) continue;
            this.assignEdits(claim, phDaySpan);
        }
        return false;
    }

    private final boolean applyAdmissionImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        if (partialHospitalizationDaySpanList == null) {
            return true;
        }
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (phDaySpan.isHourlyThresholdNotMet()) {
                boolean applyEdit = true;
                if (phDaySpan.firstSpan) {
                    if (!claim.isConditionCodePresent("MP")) {
                        claim.getConditionCodeOutputList().addValue("MP");
                    }
                    applyEdit = false;
                }
                if (phDaySpan.lastSpan && phDaySpan.getDayCount() < 7) {
                    applyEdit = false;
                }
                if (applyEdit) {
                    this.assignEdits(claim, phDaySpan);
                }
            }
            if (!phDaySpan.lastSpan) continue;
            if (phDaySpan.getDayCount() < 7) {
                String valueCodeOutput = phDaySpan.hourlyServiceCount.getHourlyServiceCountAsString();
                claim.getValueCodeOutputList().setValue(ValueCodeValue.QW.position, ValueCodeValue.QW.code, valueCodeOutput);
                continue;
            }
            claim.getValueCodeOutputList().setValue(ValueCodeValue.QW.position, ValueCodeValue.QW.code, DEFAULT_VALUE_CODE_FIELD);
        }
        return false;
    }

    private final boolean applyInterimImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        if (partialHospitalizationDaySpanList == null) {
            return true;
        }
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (phDaySpan.isHourlyThresholdNotMet()) {
                boolean applyEdit = true;
                if (phDaySpan.firstSpan) {
                    if (phDaySpan.hourlyServiceCount.days < 7) {
                        applyEdit = false;
                    }
                    if (!phDaySpan.hourlyServiceCount.emptyValueCode) {
                        claim.getConditionCodeOutputList().addValue("MV");
                    }
                }
                if (phDaySpan.lastSpan) {
                    if (phDaySpan.hourlyServiceCount.days < 7) {
                        applyEdit = false;
                    }
                    if (claim.isConditionCodePresent("MW")) {
                        applyEdit = true;
                    }
                }
                if (applyEdit) {
                    this.assignEdits(claim, phDaySpan);
                }
            }
            if (!phDaySpan.lastSpan) continue;
            if (phDaySpan.getDayCount() < 7) {
                String valueCodeOutput = phDaySpan.hourlyServiceCount.getHourlyServiceCountAsString();
                claim.getValueCodeOutputList().setValue(ValueCodeValue.QW.position, ValueCodeValue.QW.code, valueCodeOutput);
                continue;
            }
            claim.getValueCodeOutputList().setValue(ValueCodeValue.QW.position, ValueCodeValue.QW.code, DEFAULT_VALUE_CODE_FIELD);
        }
        return false;
    }

    private final boolean applyDischargeImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        if (partialHospitalizationDaySpanList == null) {
            return true;
        }
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (!phDaySpan.isHourlyThresholdNotMet()) continue;
            boolean applyEdit = true;
            if (phDaySpan.lastSpanOfCompleteDays) {
                if (!claim.isConditionCodePresent("MQ")) {
                    claim.getConditionCodeOutputList().addValue("MQ");
                }
                applyEdit = false;
            }
            if (phDaySpan.lastSpan && !claim.isConditionCodePresent("MW")) {
                applyEdit = false;
            }
            if (applyEdit && phDaySpan.firstSpan && !phDaySpan.hourlyServiceCount.emptyValueCode) {
                claim.getConditionCodeOutputList().addValue("MV");
            }
            if (!applyEdit) continue;
            this.assignEdits(claim, phDaySpan);
        }
        return false;
    }

    private final boolean applyAdjustmentImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isConditionCodePresent("MW")) {
            return false;
        }
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        if (partialHospitalizationDaySpanList == null) {
            return true;
        }
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (phDaySpan.isHourlyThresholdNotMet()) {
                // empty if block
            }
            if (phDaySpan.lastSpan) {
                if (phDaySpan.getDayCount() < 7) {
                    String valueCodeOutput = phDaySpan.hourlyServiceCount.getHourlyServiceCountAsString();
                    claim.getValueCodeOutputList().setValue(ValueCodeValue.QW.position, ValueCodeValue.QW.code, valueCodeOutput);
                } else {
                    claim.getValueCodeOutputList().setValue(ValueCodeValue.QW.position, ValueCodeValue.QW.code, DEFAULT_VALUE_CODE_FIELD);
                }
            }
            if (!phDaySpan.lastSpan) continue;
            this.assignEdits(claim, phDaySpan);
        }
        return false;
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isEditPresent(EditValue.INPATIENT_PROCEDURE_CONFLICT)) {
            switch (claim.getBillType().getFrequency()) {
                case '1': {
                    return this.applyAdmissionToDischargeImplementation(processor);
                }
                case '2': {
                    return this.applyAdmissionImplementation(processor);
                }
                case '3': {
                    return this.applyInterimImplementation(processor);
                }
                case '4': {
                    return this.applyDischargeImplementation(processor);
                }
                case '7': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'M': 
                case 'Q': {
                    return this.applyAdjustmentImplementation(processor);
                }
            }
        }
        return false;
    }

    private final class PartialHospitalizationDaySpan {
        private static final int HOURLY_THRESHOLD = 2000;
        private final HourlyServiceCount hourlyServiceCount;
        private final DaySpan daySpan;
        private boolean firstSpan;
        private boolean lastSpan;
        private boolean lastSpanOfCompleteDays;

        private PartialHospitalizationDaySpan(DaySpan daySpan) {
            this.hourlyServiceCount = new HourlyServiceCount();
            this.daySpan = daySpan;
        }

        private final void calculateTotalHours() {
            int hourCount = 0;
            for (Day day : this.daySpan.getList()) {
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.DATA_HCPCS_PH_ADDON)) continue;
                    switch (line.getTableData().getPartialHospitalizationDuration()) {
                        case 0: {
                            hourCount += line.getUnitsAsPrimitive() * 100;
                            break;
                        }
                        case 1: {
                            hourCount += line.getUnitsAsPrimitive() * 25;
                            break;
                        }
                        case 2: {
                            hourCount += line.getUnitsAsPrimitive() * 50;
                            break;
                        }
                        case 3: {
                            hourCount += line.getUnitsAsPrimitive() * 75;
                            break;
                        }
                    }
                }
            }
            this.hourlyServiceCount.hours = hourCount;
            this.hourlyServiceCount.days = this.daySpan.getCount();
        }

        private final int getDayCount() {
            return this.hourlyServiceCount.days;
        }

        private final boolean isHourlyThresholdNotMet() {
            return this.hourlyServiceCount.getTotalHours() < 2000;
        }
    }

    private final class HourlyServiceCount {
        private boolean emptyValueCode;
        private int days;
        private int hours;
        private int fractionalHour;

        private HourlyServiceCount() {
        }

        private HourlyServiceCount(String dateString) {
            this.days = Integer.parseInt(dateString.substring(4, 5));
            this.hours = Integer.parseInt(dateString.substring(5, 7)) * 100;
            this.fractionalHour = Integer.parseInt(dateString.substring(7, 9));
        }

        private final int getTotalHours() {
            return this.hours + this.fractionalHour;
        }

        private final String getHourlyServiceCountAsString() {
            return new StringBuilder(9).append("0000").append(StringUtilities.padLeft(String.valueOf(this.days), 1, '0')).append(StringUtilities.padLeft(String.valueOf(this.getTotalHours() / 100), 2, '0')).append(StringUtilities.padLeft(String.valueOf(this.getTotalHours() % 100), 2, '0')).toString();
        }
    }
}

