/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapConflictRhcDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RhcModifierConflictLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(RhcModifierConflictLogic.class);

    RhcModifierConflictLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapConflictRhcDao dao = processor.getResourceManager().getDataDaoFactory().getMapConflictRhcDao();
        short version = claim.getVersionAsPrimitive();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_RHC_MODIFIER_CONFLICT) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.isHcpcsModifierPresent("CG") || dao.getRow(line, version) == null) continue;
            claim.assignEdit(EditValue.RHC_SERVICE_NOT_ELIGIBLE_FOR_ALL_INCLUSTIVE_RATE, line);
        }
        return false;
    }
}

