/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SameDayEandMSurgeryLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(SameDayEandMSurgeryLogic.class);

    SameDayEandMSurgeryLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            boolean statusIndicatorSTPresent = false;
            boolean statusIndicatorVPresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE)) continue;
                if (line.matchesStatusIndicator("S", "T")) {
                    statusIndicatorSTPresent = true;
                    continue;
                }
                if (!line.matchesStatusIndicator("V") || line.isHcpcsModifierPresent("25")) continue;
                statusIndicatorVPresent = true;
            }
            if (!statusIndicatorSTPresent || !statusIndicatorVPresent) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.matchesStatusIndicator("V") || line.isHcpcsModifierPresent("25")) continue;
                claim.assignEdit(EditValue.VISIT_SURGURY_CONFLICT, line);
            }
        }
        return false;
    }
}

