/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class ClaimDate {
    private String value;
    private String description;
    private LocalDate dateValue;

    public ClaimDate() {
    }

    public ClaimDate(String value) {
        this(value, null);
    }

    public ClaimDate(String value, String description) {
        this.value = value;
        this.description = description;
        this.dateValue = ClaimDate.getDateForString(value);
    }

    public ClaimDate(ClaimDate copy) {
        this(copy.value, copy.description);
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
        this.dateValue = ClaimDate.getDateForString(value);
    }

    public final void setValue(LocalDate value) {
        this.dateValue = value;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        this.value = this.dateValue.format(formatter);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final LocalDate getValueAsDate() {
        return this.dateValue;
    }

    public final boolean isValid() {
        return this.dateValue != null;
    }

    public static final LocalDate getDateForString(String dateString) {
        String year = dateString.substring(0, 4);
        String month = dateString.substring(4, 6);
        String dayOfMonth = dateString.substring(6);
        return LocalDate.of(Integer.parseInt(year, 10), Integer.parseInt(month, 10), Integer.parseInt(dayOfMonth, 10));
    }

    public static final LocalDate getDateForInteger(Integer date) {
        return ClaimDate.getDateForString(String.valueOf(date));
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.description, this.dateValue);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClaimDate o = (ClaimDate)object;
        return Objects.equals(this.value, o.value) && Objects.equals(this.description, o.description) && Objects.equals(this.dateValue, o.dateValue);
    }
}

