/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.model.rsc.Sequencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeAdjustmentFlagSequencer
implements Sequencer<String> {
    private static final Logger logger = LoggerFactory.getLogger(CompositeAdjustmentFlagSequencer.class);
    private static final String ALPHA_STRING = "ABCDEFGHIJKLMNPQRSTUVWXYZ";
    private int count = 0;

    @Override
    public final void reset() {
        this.count = 0;
    }

    @Override
    public final String getCurrentValue() {
        StringBuilder nextValue = new StringBuilder();
        if (this.count < 1) {
            nextValue.append("00");
        } else if (this.count < 10) {
            nextValue.append('0').append(this.count);
        } else if (this.count < 100) {
            nextValue.append(this.count);
        } else if (this.count < 325) {
            int offset = this.count - 100;
            int length = 9;
            int part1 = offset / 9;
            nextValue.append(ALPHA_STRING.substring(part1, part1 + 1));
            int part2 = offset % 9;
            nextValue.append(part2 + 1);
        } else if (this.count < 950) {
            int offset = this.count - 325;
            int length = ALPHA_STRING.length();
            int part1 = offset / length;
            nextValue.append(ALPHA_STRING.substring(part1, part1 + 1));
            int part2 = offset % length;
            nextValue.append(ALPHA_STRING.substring(length - (length - part2), length - (length - part2) + 1));
        } else {
            nextValue.append("00");
        }
        return nextValue.toString();
    }

    @Override
    public final String getNextValue() {
        ++this.count;
        return this.getCurrentValue();
    }
}

