/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClaimModel {
    public static final int RATE_OF_GROWTH = 16;
    private final ClaimDefinition definition;
    private List<RecordModel> records;

    private ClaimModel() {
        this(null);
    }

    public ClaimModel(ClaimDefinition definition) {
        this.definition = definition;
    }

    public final ClaimDefinition getDefinition() {
        return this.definition;
    }

    public final boolean isInput() {
        return this.definition.isInput();
    }

    public final boolean isOutput() {
        return this.definition.isOutput();
    }

    public final boolean addRecord(RecordModel record) {
        if (this.records == null) {
            this.records = new ArrayList<RecordModel>(16);
        }
        return this.records.add(record);
    }

    public final boolean addRecord(RecordModel record, int index) {
        if (this.records == null) {
            this.records = new ArrayList<RecordModel>(16);
        }
        this.records.add(index, record);
        return true;
    }

    public final boolean removeRecord(RecordModel record) {
        if (this.records != null) {
            boolean changed = false;
            while (this.records.remove(record)) {
                if (changed) continue;
                changed = true;
            }
            if (changed && this.records.isEmpty()) {
                this.records = null;
            }
            return changed;
        }
        return false;
    }

    public final Iterator<RecordModel> iterator() {
        return this.records.iterator();
    }

    public final RecordModel getRecord(String id, int index) {
        for (RecordModel r : this.records) {
            if (!id.equals(r.definition.id) || --index >= 0) continue;
            return r;
        }
        return null;
    }

    public final int getLastRecordIndex(String id) {
        int i = this.records.size();
        while (-1 < --i && !id.equals(this.records.get((int)i).definition.id)) {
        }
        return i;
    }

    public final RecordModel getRecord(String id) {
        return this.getRecord(id, 0);
    }

    public final List<RecordModel> getRecords(String id) {
        ArrayList<RecordModel> list = new ArrayList<RecordModel>();
        for (RecordModel r : this.records) {
            if (!id.equals(r.definition.id)) continue;
            list.add(r);
        }
        return list;
    }

    public final List<RecordModel> getRecords() {
        return this.records;
    }

    public final boolean contains(RecordDefinition record) {
        for (RecordDefinition r : this.definition.records) {
            if (r != record) continue;
            return true;
        }
        return false;
    }
}

