/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.DefinitionLoader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClaimModelFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClaimModelFactory.class);
    private ClaimDefinition definition;
    private final String claimDefinitionFile;
    private final String recordDefinitionFile;
    private final String fieldDefinitionFile;

    private ClaimModelFactory() throws IOException {
        this(null, null, null);
    }

    public ClaimModelFactory(String claimDefinitionFile, String recordDefinitionFile, String fieldDefinitionFile) throws IOException {
        this.claimDefinitionFile = claimDefinitionFile;
        this.recordDefinitionFile = recordDefinitionFile;
        this.fieldDefinitionFile = fieldDefinitionFile;
        this.init();
    }

    private final void init() throws IOException {
        DefinitionLoader loader = new DefinitionLoader();
        loader.setFieldDefinitionFile(this.fieldDefinitionFile);
        loader.setRecordDefinitionFile(this.recordDefinitionFile);
        loader.setClaimDefinitionFile(this.claimDefinitionFile);
        this.definition = loader.loadClaimDefinition();
    }

    public final ClaimDefinition getDefinition() {
        return this.definition;
    }

    public final String getClaimDefinitionFile() {
        return this.claimDefinitionFile;
    }

    public final String getRecordDefinitionFile() {
        return this.recordDefinitionFile;
    }

    public final String getFieldDefinitionFile() {
        return this.fieldDefinitionFile;
    }

    public final ClaimModel create() {
        return new ClaimModel(this.definition);
    }
}

