/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimDefinitionLoader;
import gov.cms.oce.util.converter.rsc.DefinitionList;
import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.FieldDefinitionLoader;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordDefinitionLoader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionLoader {
    protected static final Logger logger = LoggerFactory.getLogger(DefinitionLoader.class);
    private ClaimDefinition claimDefinition;
    protected String fieldDefinitionFile;
    protected String recordDefinitionFile;
    protected String claimDefinitionFile;

    public DefinitionLoader() {
    }

    public DefinitionLoader(String fieldDefinitionFile, String recordDefinitionFile, String claimDefinitionFile) {
        this.fieldDefinitionFile = fieldDefinitionFile;
        this.recordDefinitionFile = recordDefinitionFile;
        this.claimDefinitionFile = claimDefinitionFile;
    }

    public final ClaimDefinition getClaimDefinition() {
        return this.claimDefinition;
    }

    public final String getFieldDefinitionFile() {
        return this.fieldDefinitionFile;
    }

    public final void setFieldDefinitionFile(String fieldDefinitionFile) {
        this.fieldDefinitionFile = fieldDefinitionFile;
    }

    public final String getRecordDefinitionFile() {
        return this.recordDefinitionFile;
    }

    public final void setRecordDefinitionFile(String recordDefinitionFile) {
        this.recordDefinitionFile = recordDefinitionFile;
    }

    public final String getClaimDefinitionFile() {
        return this.claimDefinitionFile;
    }

    public final void setClaimDefinitionFile(String claimDefinitionFile) {
        this.claimDefinitionFile = claimDefinitionFile;
    }

    public final DefinitionList<ClaimDefinition> load() throws IOException {
        FieldDefinitionLoader fieldDefinitionLoader = new FieldDefinitionLoader();
        fieldDefinitionLoader.setFilePath(this.fieldDefinitionFile);
        DefinitionList<FieldDefinition> fieldDefinitionList = fieldDefinitionLoader.load();
        RecordDefinitionLoader recordDefinitionLoader = new RecordDefinitionLoader();
        recordDefinitionLoader.setFilePath(this.recordDefinitionFile);
        recordDefinitionLoader.setLookupList(fieldDefinitionList);
        DefinitionList<RecordDefinition> recordDefinitionList = recordDefinitionLoader.load();
        ClaimDefinitionLoader claimDefinitionLoader = new ClaimDefinitionLoader();
        claimDefinitionLoader.setFilePath(this.claimDefinitionFile);
        claimDefinitionLoader.setLookupList(recordDefinitionList);
        return claimDefinitionLoader.load();
    }

    public final ClaimDefinition loadClaimDefinition() throws IOException {
        return this.load().getItem(0);
    }
}

