/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.Record;
import java.util.Collections;
import java.util.List;

public class RecordDefinition
implements Record<FieldDefinition> {
    final String id;
    final String group;
    final boolean input;
    final boolean output;
    final int length;
    final List<FieldDefinition> fields;
    final String linePrototype;

    private RecordDefinition() {
        this(null, null, false, false, null);
    }

    public RecordDefinition(String id, boolean input, boolean output, List<FieldDefinition> fields) {
        this(id, null, input, output, fields);
    }

    public RecordDefinition(String id, String group, boolean input, boolean output, List<FieldDefinition> fields) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.fields = Collections.unmodifiableList(fields);
        int l = 0;
        for (FieldDefinition field : fields) {
            l += field.length * field.count;
        }
        this.length = l;
        char[] prototype = new char[this.length];
        for (FieldDefinition field : fields) {
            int i = field.position - 1;
            while (++i < field.getEndOffset()) {
                prototype[i] = field.fillChar;
            }
        }
        this.linePrototype = new String(prototype);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getGroup() {
        return this.group;
    }

    @Override
    public final boolean isInput() {
        return this.input;
    }

    @Override
    public final boolean isOutput() {
        return this.output;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final List<FieldDefinition> getFields() {
        return this.fields;
    }

    @Override
    public final FieldDefinition getField(String id) {
        for (FieldDefinition field : this.fields) {
            if (!id.equals(field.id)) continue;
            return field;
        }
        return null;
    }

    @Override
    public final boolean contains(FieldDefinition field) {
        for (FieldDefinition f : this.fields) {
            if (f != field) continue;
            return true;
        }
        return false;
    }
}

