/*
 * Decompiled with CFR 0.152.
 */
package com.component;

import com.modal.Diagnosis;
import com.modal.Procedure;
import com.modal.ValueCodes;
import com.modal.claim.GrouperInput;
import com.modal.claim.GrouperOutput;
import com.util.StringUtils;
import gov.cms.oce.api.OceClaimExecutor;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceClaimFactory;
import gov.cms.oce.model.external.OceLineItem;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentManager {
    private static final Logger logger = LoggerFactory.getLogger(ComponentManager.class);
    private GrouperInput grouperInput;
    private GrouperOutput grouperOutput;
    private OceClaimExecutor claimExecutor;

    public ComponentManager(GrouperInput grouperInput, GrouperOutput grouperOutput) {
        this.grouperInput = grouperInput;
        this.grouperOutput = grouperOutput;
        this.claimExecutor = new OceClaimExecutor();
    }

    public ComponentManager() {
        this.claimExecutor = new OceClaimExecutor();
    }

    public String getProcDescription(String fsDate, String thruDate, String code) {
        return this.claimExecutor.getLatestHcpcsDescription(code);
    }

    public String getDXDescription(String fsDate, String thruDate, String code) {
        return this.claimExecutor.getLatestDiagnosisDescription(code);
    }

    public String getProcDescription(String fsDate, String code) {
        return this.claimExecutor.getLatestHcpcsDescription(code);
    }

    public String getEditDescription(String editString) {
        return this.claimExecutor.getLatestEditDescription(editString);
    }

    public OceClaim processFixedClaim() {
        OceClaim claim;
        try {
            Procedure proc;
            Diagnosis diagnosis;
            Diagnosis diagnosis2;
            claim = OceClaimFactory.getInstance().createClaim();
            Iterator iterator = this.grouperInput.getRvdxList().iterator();
            while (iterator.hasNext() && !StringUtils.isNullOrWhitespace((diagnosis2 = (Diagnosis)iterator.next()).getCode())) {
                claim.addReasonForVisitDiagnosisCode(StringUtils.trim(diagnosis2.getCode()), "");
            }
            Diagnosis principalDiagnosis = this.grouperInput.getPdxList().stream().findFirst().orElse(null);
            if (principalDiagnosis != null) {
                claim.setPrincipalDiagnosisCode(StringUtils.trim(principalDiagnosis.getCode()), "");
            }
            Iterator<Object> iterator2 = this.grouperInput.getSdxList().iterator();
            while (iterator2.hasNext() && !StringUtils.isNullOrWhitespace((diagnosis = (Diagnosis)iterator2.next()).getCode())) {
                claim.addSecondaryDiagnosisCode(StringUtils.trim(diagnosis.getCode()), "");
            }
            iterator2 = this.grouperInput.getProcedures().iterator();
            while (!(!iterator2.hasNext() || StringUtils.isNullOrWhitespace((proc = (Procedure)iterator2.next()).getServiceDate()) && StringUtils.isNullOrWhitespace(proc.getRevenueCode()))) {
                OceLineItem line = OceClaimFactory.getInstance().createLineItem();
                line.setActionFlagInput(proc.getLineItemActionFlagInput());
                line.setContractorApc(proc.getCbAPC());
                line.setContractorRejectionDenialFlag(proc.getCbDenialRejection());
                line.setContractorDiscountingFormula(proc.getCbDiscountingFormula());
                line.addContractorEditBypass(proc.getCbEdit1());
                line.addContractorEditBypass(proc.getCbEdit2());
                line.addContractorEditBypass(proc.getCbEdit3());
                line.addContractorEditBypass(proc.getCbEdit4());
                line.setContractorPackagingFlag(proc.getCbPackagingFlag());
                line.setContractorPaymentAdjustmentFlag01(proc.getCbPaymentAdjustmentFlag());
                line.setContractorPaymentAdjustmentFlag02(proc.getCbPaymentAdjustmentFlag2());
                line.setContractorPaymentIndicator(proc.getCbPaymentIndicator());
                line.setContractorPaymentMethodFlag(proc.getCbPaymentMethodFlag());
                line.setContractorStatusIndicator(proc.getCbStatusIndicator());
                line.setHcpcs(proc.getCode());
                line.addHcpcsModifierInput(proc.getModifier1());
                line.addHcpcsModifierInput(proc.getModifier2());
                line.addHcpcsModifierInput(proc.getModifier3());
                line.addHcpcsModifierInput(proc.getModifier4());
                line.addHcpcsModifierInput(proc.getModifier5());
                line.setRevenueCode(proc.getRevenueCode());
                line.setServiceDate(proc.getServiceDateDomainFormat());
                line.setUnitsInput(proc.getUnitsInput());
                line.setCharge(proc.getChargeInput());
                claim.addLineItem(line);
            }
            claim.setAge(this.grouperInput.getAge());
            claim.setSex(this.grouperInput.getSex());
            claim.setDateStarted(this.grouperInput.getFromDateDomainFormat());
            claim.setDateEnded(this.grouperInput.getThruDateDomainFormat());
            claim.setReceiptDate(this.grouperInput.getReceiptDateDomainFormat());
            for (String conditionCode : this.grouperInput.getConditionCodes()) {
                claim.addConditionCodeInput(conditionCode);
            }
            claim.setBillType(this.grouperInput.getBillType());
            claim.setCmsCertificationNumber(this.grouperInput.getCCN());
            claim.setPatientStatus(this.grouperInput.getPatientStatus());
            claim.setOppsFlag(this.grouperInput.getOpps());
            for (String occurrenceCode : this.grouperInput.getOccurrenceCodes()) {
                claim.addOccurrenceCodeInput(occurrenceCode);
            }
            for (ValueCodes valueCode : this.grouperInput.getValueCodes()) {
                claim.addValueCodeInput(valueCode.getValueCode(), valueCode.getAmount());
            }
            this.claimExecutor.processClaim(claim);
            this.grouperOutput.addLineLevelOutput(claim);
            this.grouperOutput.addClaimLevelOutputs(claim, this.claimExecutor);
            this.grouperOutput.addDXEdits(claim, this.claimExecutor);
            this.grouperOutput.setReturnCode(claim, this.claimExecutor);
        }
        catch (Exception e) {
            logger.error("Error when processing claim...", e);
            return null;
        }
        return claim;
    }

    public void setGrouperInput(GrouperInput grouperInput) {
        this.grouperInput = grouperInput;
    }

    public void setGrouperOutput(GrouperOutput grouperOutput) {
        this.grouperOutput = grouperOutput;
    }
}

