/*
 * Decompiled with CFR 0.152.
 */
package com.component;

import com.constants.Component_EN;
import com.constants.Constants;
import com.modal.Diagnosis;
import com.modal.Edit;
import com.modal.Procedure;
import com.modal.claim.GrouperInput;
import com.modal.claim.GrouperOutput;
import java.util.Arrays;
import java.util.List;

public class ReportGenerator {
    private StringBuilder sb = new StringBuilder();
    private GrouperInput grouperInput;
    private GrouperOutput grouperOutput;
    private Constants _CONSTANTS_ = new Constants(Component_EN.IOCE);

    public ReportGenerator(GrouperInput grouperInput, GrouperOutput grouperOutput) {
        this.grouperInput = grouperInput;
        this.grouperOutput = grouperOutput;
    }

    private static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s.trim());
    }

    private void add(String label, String value, int column) {
        if (column > 0) {
            this.sb.append(ReportGenerator.padRight(String.format("%s%s", label, value), column));
        } else {
            this.sb.append(String.format("%s%s", label, value));
        }
    }

    private void add(String label, List<String> values, int column) {
        String vals = Arrays.toString(values.toArray()).replace(",", "").replace("[", "").replace("]", "");
        if (column > 0) {
            this.sb.append(ReportGenerator.padRight(String.format("%s%s", label, vals), column));
        } else {
            this.sb.append(String.format("%s%s", label, vals));
        }
    }

    private void add(String label, List<Edit> values) {
        boolean result = values.stream().anyMatch(obj -> !obj.getEdit().trim().isEmpty());
        if (result) {
            this.sb.append(label);
        }
        values.forEach(e -> {
            if (!e.getEdit().trim().isEmpty()) {
                this.sb.append(e.toFormattedString(this.grouperInput.getFromDateDomainFormat()));
                this.sb.append("\n");
            }
        });
    }

    private void addDiagnosis(String label, List<Diagnosis> values) {
        boolean result = values.stream().anyMatch(obj -> !obj.getCode().trim().isEmpty());
        if (result) {
            this.sb.append(label);
        }
        values.forEach(e -> {
            if (!e.getCode().trim().isEmpty()) {
                this.sb.append(e.toFormattedString(this.grouperInput.getFromDateDomainFormat(), this.grouperInput.getThruDateDomainFormat()));
                this.sb.append("\n");
            }
        });
    }

    private void addProcedure(String label, List<Procedure> values) {
        boolean result = values.stream().anyMatch(obj -> !obj.getServiceDate().trim().isEmpty());
        if (result) {
            this.sb.append(label);
        }
        values.forEach(e -> {
            if (!e.getServiceDate().trim().isEmpty()) {
                this.sb.append(e.toFormattedString(this.grouperInput.getFromDateDomainFormat()));
                this.sb.append("\n");
            }
        });
    }

    private void writeClaimOutput() {
        String _AGE_ = "Age (years):";
        String _BIRTH_DATE_ = "Birth Date:";
        String _COMMENT_ = "Comment:";
        String _CONDITION_CODES_ = "Condition Codes:";
        String _FROM_DATE_ = "From Date:";
        String _MEDICAL_RECORD_ = "Medical Record Number:";
        String _OCCURRENCE_CODES_ = "Occurrence Codes:";
        String _OCE_VERSION_ = "OCE Version Used:";
        String _OPPS_FLAG_ = "OPPS Flag:";
        String _PATIENT_ACCOUNT_NUMBER_ = "Account #:";
        String _CCN_ = "CCN:";
        String _PAY_SOURCE_ = "Pay Source:";
        String _PATIENT_NAME_ = "Patient Name:";
        String _PATIENT_STATUS_ = "Patient Status:";
        String _PAYER_CONDITION_CODES_ = "Payer Condition Codes:";
        String _PRINCIPAL_DIAGNOSIS_ = "Principal Diagnosis:\n";
        String _PROCEDURES_ = "Procedures:\n";
        String _REASON_DX_DIAGNOSIS_ = "Reason For Visit Diagnosis:\n";
        String _REPORT_HEADER_ = this._CONSTANTS_.getReportTitle();
        String _SECONDARY_DIAGNOSIS_ = "Secondary Diagnosis:\n";
        String _SEX_ = "Sex:";
        String _THROUGH_DATE_ = "Through Date:";
        String _RECEIPT_DATE_ = "Receipt Date:";
        String _TYPE_OF_BILL_ = "Bill Type:";
        String _VALUE_CODES_INPUT_ = "Value Codes (Input):\n";
        String _VALUE_CODES_OUTPUT_ = "Value Codes (Output):";
        String _OVERALL_CLAIM_DISPOSITION_ = "Overall Claim Disposition:";
        String _CLAIM_PROCESSING_FLAG_ = "Claim Processing Flag:";
        String _GROUPER_RETURN_CODE_ = "Grouper Return Code:";
        String _BUFFER_COMPLETED_ = "APC Buffer Return Flag:";
        String _CLAIM_REJECTION_EDITS_ = "Claim Rejection Edits:\n";
        String _CLAIM_DENIAL_EDITS_ = "Claim Denial Edits:\n";
        String _CLAIM_RTP_EDITS_ = "Claim Return To Provider Edits:\n";
        String _CLAIM_MEDICAL_SUSPEND_EDITS_ = "Claim Medical Suspend Edits:\n";
        String _CLAIM_LINE_ITEM_REJECTION_EDITS_ = "Claim Line Item Rejection Edits:\n";
        String _CLAIM_LINE_ITEM_DENIAL_EDITS_ = "Claim Line Item Denial Edits:\n";
        String _CLAIM_REJECTION_DISPOSITION_ = "Claim Rejection Disposition: ";
        String _CLAIM_DENIAL_DISPOSITION_ = "Claim Denial Disposition: ";
        String _CLAIM_RTP_DISPOSITION_ = "Claim Return To Provider Disposition: ";
        String _CLAIM_SUSPENSION_DISPOSITION_ = "Claim Suspension Disposition: ";
        String _LINE_ITEM_REJECTION_DISPOSITION_ = "Line Item Rejection Disposition: ";
        String _LINE_ITEM_DENIAL_DISPOSITION_ = "Line Item Denial Disposition: ";
        int column = 28;
        this.sb = new StringBuilder();
        this.add(_REPORT_HEADER_, "\n", 0);
        this.add("Patient Name:", this.grouperInput.getPatientName(), 28);
        this.add("Medical Record Number:", this.grouperInput.getMedicalRecordNumber(), 28);
        this.add("CCN:", this.grouperInput.getCCN(), 28);
        this.add("", "\n", 0);
        this.add("From Date:", this.grouperInput.getFromDateReportFormat(), 28);
        this.add("Through Date:", this.grouperInput.getThruDateReportFormat(), 28);
        this.add("Receipt Date:", this.grouperInput.getReceiptDateReportFormat(), 28);
        this.add("OPPS Flag:", this.grouperInput.getOpps(), 0);
        this.add("", "\n", 0);
        this.add("Birth Date:", this.grouperInput.getBirthDateReportFormat(), 28);
        this.add("Age (years):", this.grouperInput.getAge(), 28);
        this.add("Sex:", this.grouperInput.getSex(), 0);
        this.add("", "\n", 0);
        this.add("Patient Status:", this.grouperInput.getPatientStatus(), 28);
        this.add("Bill Type:", this.grouperInput.getBillType(), 28);
        this.add("OCE Version Used:", this.grouperOutput.getOceVersionUsed(), 0);
        this.add("", "\n", 0);
        this.add("Pay Source:", this.grouperInput.getPaySource(), 28);
        this.add("Account #:", this.grouperInput.getAccountNumber(), 28);
        this.add("Comment:", this.grouperInput.getComment(), 0);
        this.add("", "\n", 0);
        this.add("Condition Codes:", this.grouperInput.getConditionCodes(), 0);
        this.add("", "\n", 0);
        this.add("Occurrence Codes:", this.grouperInput.getOccurrenceCodes(), 0);
        this.add("", "\n", 0);
        this.add("Payer Condition Codes:", this.grouperOutput.getPayerConditionCodes(), 0);
        this.add("", "\n", 0);
        this.add("Value Codes (Input):\n", this.grouperInput.getFormattedValueCodes(), 0);
        this.add("", "\n", 0);
        this.add("Value Codes (Output):", this.grouperOutput.getFormattedValueCodes(), 0);
        this.add("", "\n", 0);
        this.add("", "\n", 0);
        this.add("Claim Rejection Edits:\n", this.grouperOutput.getClaimRejectionEdits());
        this.add("Claim Denial Edits:\n", this.grouperOutput.getClaimDenialEdits());
        this.add("Claim Return To Provider Edits:\n", this.grouperOutput.getClaimRtpEdits());
        this.add("Claim Medical Suspend Edits:\n", this.grouperOutput.getClaimMedicalSuspendEdits());
        this.add("Claim Line Item Rejection Edits:\n", this.grouperOutput.getClaimLineItemRejectionEdits());
        this.add("Claim Line Item Denial Edits:\n", this.grouperOutput.getClaimLineItemDenialEdits());
        this.addDiagnosis("Principal Diagnosis:\n", (List<Diagnosis>)this.grouperInput.getPdxList());
        this.addDiagnosis("Secondary Diagnosis:\n", (List<Diagnosis>)this.grouperInput.getSdxList());
        this.addDiagnosis("Reason For Visit Diagnosis:\n", (List<Diagnosis>)this.grouperInput.getRvdxList());
        this.addProcedure("Procedures:\n", this.grouperOutput.getProcedureArrayList());
        this.add("", "\n", 0);
        this.add("Grouper Return Code:", this.grouperOutput.getReturnCode().getValueAndDescription(), 0);
        this.add("Overall Claim Disposition:", this.grouperOutput.getOverallClaimDisposition().getValueAndDescription(), 0);
        this.add("", "\n", 0);
        this.add("Claim Rejection Disposition: ", this.grouperOutput.getClaimRejectionDisposition().getValueAndDescription(), 0);
        this.add("Claim Denial Disposition: ", this.grouperOutput.getClaimDenialDisposition().getValueAndDescription(), 0);
        this.add("Claim Return To Provider Disposition: ", this.grouperOutput.getClaimRTPDisposition().getValueAndDescription(), 0);
        this.add("Claim Suspension Disposition: ", this.grouperOutput.getClaimSuspensionDisposition().getValueAndDescription(), 0);
        this.add("", "\n", 0);
        this.add("Line Item Rejection Disposition: ", this.grouperOutput.getLineItemRejectionDisposition().getValueAndDescription(), 0);
        this.add("Line Item Denial Disposition: ", this.grouperOutput.getLineItemDenialDisposition().getValueAndDescription(), 0);
        this.add("", "\n", 0);
        this.add("APC Buffer Return Flag:", this.grouperOutput.getBufferCompleted(), 0);
        this.add("", "\n", 0);
        this.add("Claim Processing Flag:", this.grouperOutput.getClaimProcessedFlag().getValueAndDescription(), 0);
        this.add("", "\n", 0);
        this.add(Constants._AMA_MESSAGE_LONG_, "", 0);
    }

    public String getFormattedReport() {
        this.writeClaimOutput();
        return this.sb.toString();
    }
}

