/*
 * Decompiled with CFR 0.152.
 */
package com.constants.batch;

import com.constants.batch.DomainUtils_IN;
import com.constants.batch.ProcedureLevel_IN;
import com.modal.Procedure;
import com.util.StringUtils;

public enum BatchProcedureInput_EN implements ProcedureLevel_IN
{
    CODE(21, 5, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCode(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCode(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    MODIFIER(26, 10, 2, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setModifier1(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getBufferStart() + 2));
            procedure.setModifier2(DomainUtils_IN.getValue(line, this.getBufferStart() + 2, this.getBufferStart() + 4));
            procedure.setModifier3(DomainUtils_IN.getValue(line, this.getBufferStart() + 4, this.getBufferStart() + 6));
            procedure.setModifier4(DomainUtils_IN.getValue(line, this.getBufferStart() + 6, this.getBufferStart() + 8));
            procedure.setModifier5(DomainUtils_IN.getValue(line, this.getBufferStart() + 8, this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getModifier1() + procedure.getModifier2() + procedure.getModifier3() + procedure.getModifier4() + procedure.getModifier5(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    SERVICE_DATE(36, 8, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            String v = DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd());
            if (v.trim().length() < 8) {
                procedure.setServiceDate(v);
            } else {
                procedure.setServiceDate(StringUtils.convertToDomainDate(v, "yyyyMMdd", "MMddyyyy"));
            }
        }

        @Override
        public String print(Procedure procedure, String line) {
            String v = procedure.getServiceDate();
            if (v.trim().length() < 8) {
                return DomainUtils_IN.domainStringCombine(line, v, this.getBufferStart(), this.getEnd());
            }
            return DomainUtils_IN.domainStringCombine(line, StringUtils.convertToDomainDate(v, "MMddyyyy", "yyyyMMdd"), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    REVENUE_CODE(44, 4, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setRevenueCode(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getRevenueCode(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    UNITS(48, 9, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setUnitsInput(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getUnitsInput(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CHARGES(57, 10, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setChargeInput(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getChargeInput(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LIAF(67, 1, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setLineItemActionFlagInput(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getLineItemActionFlagInput(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_EDITS(68, 12, 3, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbEdit1(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getBufferStart() + 3));
            procedure.setCbEdit2(DomainUtils_IN.getValue(line, this.getBufferStart() + 3, this.getBufferStart() + 6));
            procedure.setCbEdit3(DomainUtils_IN.getValue(line, this.getBufferStart() + 6, this.getBufferStart() + 9));
            procedure.setCbEdit4(DomainUtils_IN.getValue(line, this.getBufferStart() + 9, this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbEdit1() + procedure.getCbEdit2() + procedure.getCbEdit3() + procedure.getCbEdit4(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_APC(80, 5, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbAPC(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbAPC(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_SI(85, 2, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbStatusIndicator(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbStatusIndicator(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_PI(87, 2, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbPaymentIndicator(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbPaymentIndicator(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_DF(89, 1, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbDiscountingFormula(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbDiscountingFormula(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_LIDRF(90, 1, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbDenialRejection(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbDenialRejection(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_PKG(91, 1, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbPackagingFlag(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbPackagingFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_PAF(92, 2, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbPaymentAdjustmentFlag(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbPaymentAdjustmentFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_PMF(94, 1, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbPaymentMethodFlag(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbPaymentMethodFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CB_PAF2(95, 2, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setCbPaymentAdjustmentFlag2(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCbPaymentAdjustmentFlag2(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    L_USER_DATA(96, 203, 0, "L"){

        @Override
        public void set(Procedure procedure, String line) {
            procedure.setUserData(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getUserData(), this.getBufferStart(), this.getEnd());
        }
    };

    private final int bufferStart;
    private final int length;
    private final int elementSize;
    private final String line;

    private BatchProcedureInput_EN(int bufferStart, int length, int elementSize, String line) {
        this.bufferStart = bufferStart;
        this.length = length;
        this.elementSize = elementSize;
        this.line = line;
    }

    public int getBufferStart() {
        return this.bufferStart;
    }

    public int getEnd() {
        return this.bufferStart + this.length;
    }

    public String getLine() {
        return this.line;
    }

    protected String cat(String line, String newValue) {
        return line.substring(0, this.getBufferStart()) + newValue + line.substring(this.getEnd());
    }
}

