/*
 * Decompiled with CFR 0.152.
 */
package com.constants.batch;

import com.constants.batch.DomainUtils_IN;
import com.constants.batch.ProcedureOutput_IN;
import com.modal.Edit;
import com.modal.Procedure;
import java.util.stream.Collectors;

public enum BatchProcedureOutput_EN implements ProcedureOutput_IN
{
    PAYMENT_APC(21, 5, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getPaymentAPC(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    HCPCS_APC(26, 5, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getHcpcsAPC(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    STATUS_INDICATOR(31, 2, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getStatusIndicator(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PAYMENT_INDICATOR(33, 2, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getPaymentIndicator(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    DISCOUNTING_FORMULA(35, 1, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getDiscountFormula(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LIDRF(36, 1, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getLineItemDenialRejectionFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PACKAGING_FLAG(37, 1, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getPackagingFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PAYMENT_ADJUSTMENT_FLAG(38, 2, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getPaymentAdjustmentFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PAYMENT_METHOD_FLAG(40, 1, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getPaymentMethodFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    UNITS(41, 9, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getUnitsOutput(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PROCEDURE_EDITS(50, 90, 3, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getProcedureEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    HCPCS(140, 5, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCodeOutput(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LIAF(145, 1, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getLineItemActionFlagOutput(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CAF(146, 2, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getCompositeAdjustmentFlag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    HCPCS_MOD(148, 4, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getHcpcsModifier(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PAYMENT_ADJUSTMENT_FLAG2(152, 2, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getPaymentAdjustmentFlag2(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    R_USER_DATA(154, 146, 1, "R"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, new String(new char[this.getLength()]).replace('\u0000', ' '), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    MOD_EDITS(21, 60, 3, "S"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getModifierEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    DATE_EDITS(81, 12, 3, "S"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getDateEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    REV_EDITS(93, 15, 3, "S"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getRevenueEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CHARGES(108, 10, 3, "S"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, procedure.getChargeOutput(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    S_USER_DATA(118, 182, 1, "S"){

        @Override
        public String print(Procedure procedure, String line) {
            return DomainUtils_IN.domainStringCombine(line, new String(new char[this.getLength()]).replace('\u0000', ' '), this.getBufferStart(), this.getEnd());
        }
    };

    private final int bufferStart;
    private final int length;
    private final int elementSize;
    private final String line;

    private BatchProcedureOutput_EN(int bufferStart, int length, int elementSize, String line) {
        this.bufferStart = bufferStart;
        this.length = length;
        this.elementSize = elementSize;
        this.line = line;
    }

    public int getBufferStart() {
        return this.bufferStart;
    }

    public int getEnd() {
        return this.bufferStart + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public String getLine() {
        return this.line;
    }
}

