/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class DomainException
extends RuntimeException {
    public static final int EcERROR_MAX_MASK = 65535;
    public static final int EcERROR_MIN_MASK = 0;
    public static final int EcERROR_TYPE_MASK = 61440;
    public static final int EcERROR_MODULE_MASK = 3840;
    public static final int EcERROR_ID_MASK = 255;
    public static final int EcERROR_WARNING = 8192;
    public static final int EcERROR_STARTUP = 16384;
    public static final int EcERROR_ECLIB = 0;
    public static final int EcERROR_INTERFACE = 256;
    public static final int EcERROR_DISPLAY = 512;
    public static final int EcERROR_KERNEL = 768;
    public static final int EcERROR_SHELL = 1024;
    public static final int EcERROR_DATABASE = 1280;
    public static final int EcERROR_LICENSE = 1536;
    public static final int EcERROR_SWITCH = 0;
    public static final int EcERROR_REQ_SWITCH = 1;
    public static final int EcERROR_MUL_SWITCH = 2;
    public static final int EcERROR_MALLOC = 3;
    public static final int EcERROR_MEM_FREE_ACCESS = 4;
    public static final int EcERROR_MEM_POOL_BOUNDS = 5;
    public static final int KEERR_EMPTY_ALLOC = 796;
    private static final ResourceBundle bundle = PropertyResourceBundle.getBundle("bundle");
    private Throwable wrappedThrowable;
    private int errorCode;
    private Object[] arr;

    public DomainException() {
    }

    public DomainException(String message) {
        super(message);
    }

    public DomainException(String message, Throwable t) {
        super(message);
        this.setWrappedThrowable(t);
    }

    public DomainException(Throwable t) {
        this.setWrappedThrowable(t);
    }

    public DomainException(int errorCode) {
        this.errorCode = errorCode;
    }

    public DomainException(int errorCode, Object[] arr) {
        this(errorCode);
        this.arr = arr;
    }

    public Throwable getWrappedThrowable() {
        return this.wrappedThrowable;
    }

    public void setWrappedThrowable(Throwable t) {
        this.wrappedThrowable = t;
    }

    @Override
    public String getMessage() {
        if (this.errorCode == 0) {
            if (this.wrappedThrowable != null) {
                return this.wrappedThrowable.getClass().getName();
            }
            return super.getMessage();
        }
        String hexStr = Integer.toHexString(this.errorCode).toUpperCase();
        String str = hexStr + "--" + MessageFormat.format(bundle.getString(hexStr), this.arr);
        return str;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.wrappedThrowable != null) {
            System.err.println("Nested Exception: ");
            this.wrappedThrowable.printStackTrace();
        }
    }
}

