/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;
import com.mmmhis.domain.ec.EcMath;
import java.math.BigDecimal;
import java.math.MathContext;
import jodd.format.Printf;

public class DomainFloat
extends DomainVariable {
    private static final long serialVersionUID = -8264946141441283544L;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final int DBL_DIG = 15;
    private static final MathContext context = new MathContext(14);
    protected double value;

    public DomainFloat() {
    }

    public DomainFloat(double value) {
        this.value = value;
    }

    private DomainFloat(DomainFloat df) {
        this.value = df.getValue();
    }

    public DomainFloat(DomainEnvironment _env, String s) {
        _env.LastError.reset();
        try {
            if (!DomainFloat.validStringToLongNumber(s)) {
                throw new NumberFormatException();
            }
            this.value = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            _env.LastError.setValue(1);
            this.value = 0.0;
        }
    }

    public DomainFloat(DomainEnvironment _env, DomainString s) {
        _env.LastError.reset();
        try {
            if (!DomainFloat.validStringToLongNumber(s.toString())) {
                throw new NumberFormatException();
            }
            this.value = Double.valueOf(s.getValue());
        }
        catch (NumberFormatException e) {
            _env.LastError.setValue(1);
            this.value = 0.0;
        }
    }

    public DomainFloat(DomainFloat[] a, int i2) {
        this.DVArray = a;
        this.DVIndex = i2;
    }

    @Override
    public void reset() {
        this.value = 0.0;
    }

    public int compareTo(DomainFloat anotherFloat) {
        return DomainFloat.compare(this.value, anotherFloat.value);
    }

    public int compareTo(Object o) {
        return this.compareTo((DomainFloat)o);
    }

    public static int compare(double d1, double d2) {
        return EcMath.floatCompare(d1, d2);
    }

    public double getValue() {
        return this.value;
    }

    public DomainFloat setValue(double value) {
        this.value = value;
        return this;
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, String s) {
        _env.LastError.reset();
        if (s == null || s.length() <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        try {
            if (!DomainFloat.validStringToLongNumber(s)) {
                throw new NumberFormatException();
            }
            this.value = Double.parseDouble(s);
            return this;
        }
        catch (NumberFormatException ex) {
            _env.LastError.setValue(1);
            this.reset();
            return this;
        }
    }

    public static boolean validStringToLongNumber(String s) {
        boolean e = false;
        boolean numbers = false;
        boolean minus = false;
        boolean point = false;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (Character.isDigit(s.charAt(i2))) {
                numbers = true;
                continue;
            }
            if (s.charAt(i2) == '.') {
                if (point) {
                    return false;
                }
                point = true;
                continue;
            }
            if (s.charAt(i2) == '-') {
                if (minus) {
                    return false;
                }
                minus = true;
                continue;
            }
            if (s.charAt(i2) == 'e' || s.charAt(i2) == 'E') {
                if (e) {
                    return false;
                }
                e = true;
                continue;
            }
            if (!numbers) continue;
            return false;
        }
        return true;
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, DomainString s) {
        return this.setValue(_env, s.toString());
    }

    @Override
    public DomainVariable setValue(DomainVariable v) {
        this.value = ((DomainFloat)v).getValue();
        return this;
    }

    @Override
    public String toString() {
        String plainStr;
        if (this.value == (double)((long)this.value)) {
            return String.valueOf((long)this.value);
        }
        BigDecimal big = new BigDecimal(String.valueOf(this.value), context).stripTrailingZeros();
        String s = String.valueOf(big.doubleValue());
        if (s.contains("E") || s.contains("e")) {
            big = new BigDecimal(this.value, context).stripTrailingZeros();
            s = String.valueOf(big.doubleValue());
        }
        if ((plainStr = big.toPlainString()).equals(big.toBigInteger().toString())) {
            s = plainStr;
        } else if (s.contains("E") || s.endsWith("0")) {
            s = Printf.str("%g", big.doubleValue());
        }
        return s;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DomainFloat) {
            return this.value == ((DomainFloat)obj).getValue();
        }
        return false;
    }

    public static double round(double v, int p) {
        return EcMath.round(v, p);
    }

    public static double round(double v, DomainInteger p) {
        return DomainFloat.round(v, p.value);
    }

    @Override
    public DomainVariable copy() {
        return new DomainFloat(this);
    }

    public static void main(String[] args) {
        int value;
        DomainFloat f1 = new DomainFloat(2101.1634);
        DomainFloat f2 = new DomainFloat(2101.1634);
        if (f1.compareTo(f2) != 0) {
            System.out.println("ERROR: f1 should equal 2101.163400");
        }
        f1.setValue(698.4599999999999);
        f2.setValue(698.46);
        if (f1.compareTo(f2) != 0) {
            System.out.println("ERROR: f1 should equal 698.460000");
        }
        f1.setValue(20156.4196353);
        f2.setValue(20156.4196353);
        if (f1.compareTo(f2) != 0) {
            System.out.println("ERROR: f1 should equal 20156.4196353");
        }
        f1.setValue(31.44064673755689);
        f2.setValue(31.440647);
        f1.setValue(10.0);
        f2.setValue(20.0);
        DomainFloat f3 = new DomainFloat(30.0);
        DomainFloat f4 = new DomainFloat(40.0);
        if (f3.compareTo(f4) == 1) {
            System.out.println("ERROR: f3 < f4");
        }
        if (f4.compareTo(f3) == -1) {
            System.out.println("ERROR: f3 < f4");
        }
        if ((value = f4.compareTo(f4)) == 1) {
            System.out.println("ERROR: f4 <= f4");
        }
    }

    @Override
    public boolean isTrue() {
        return DomainFloat.compare(this.value, 0.0) == 0;
    }

    @Override
    public DomainVariable getNewInstance(DomainVariable[] a, int i2) {
        return new DomainFloat((DomainFloat[])a, i2);
    }
}

