/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainCode;
import com.mmmhis.domain.DomainCurrency;
import com.mmmhis.domain.DomainDate;
import com.mmmhis.domain.DomainEcUtil;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainExtDate;
import com.mmmhis.domain.DomainFixedString;
import com.mmmhis.domain.DomainFloat;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainInvalidCodeException;
import com.mmmhis.domain.DomainVariable;
import com.mmmhis.domain.PrintfFormat;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class DomainString
extends DomainVariable {
    private static final long serialVersionUID = 3009577544007177272L;
    private static final int INITIAL_SIZE = 32;
    private static final String ENCRYPT = "AzBy0CxDwE1vFuGt2HsIr3JqKp5LoMn4NmO6lPk7Qj9RiSh8TgUfVeWdXcYbZa";
    private static final int ENCRYPT_LENGTH = "AzBy0CxDwE1vFuGt2HsIr3JqKp5LoMn4NmO6lPk7Qj9RiSh8TgUfVeWdXcYbZa".length();
    private static final int ENCRYPT_WRAP = ENCRYPT_LENGTH / 2;
    public static final int REPLACE_ALL = 0;
    public static final int REPLACE_FIRST = 1;
    public static final int REPLACE_LAST = 2;
    private static final char PACK_ARRAY = 'a';
    private static final char PACK_CODE = 'c';
    private static final char PACK_DATE = 'd';
    private static final char PACK_DEF_DATE = 'e';
    private static final char PACK_DEF_TIME = 'u';
    private static final char PACK_DOT = '.';
    private static final char PACK_FLOAT = 'f';
    private static final char PACK_INTEGER = 'i';
    private static final char PACK_JUMP = 'j';
    private static final char PACK_CURRENCY = 'm';
    private static final char PACK_DELIM = 'p';
    private static final char PACK_STRING = 's';
    private static final char PACK_TIME = 't';
    private static final char PACK_WIDTH = 'w';
    private static final char PACK_NONE = '!';
    private static final char PACK_UNKNOWN = '?';
    private static final int ST_WIDTH = 0;
    private static final int ST_DELIM = 1;
    private static final int ST_REST = 2;
    private static final int PACK_ZERO = 1;
    private static final int PACK_BLANK = 2;
    private static final int PACK_LEFT = 4;
    private static final int PACK_PLUS = 8;
    private static final int PACK_DYNAM = 16;
    private static final int PACK_DYNAMP = 32;
    private static final int PACK_IMPLY = 64;
    private static final int PACK_B_FORMAT = 3;
    private static final int PACK_B_FLAGS = 1;
    private static final int PACK_B_WIDTH = 2;
    private static final int PACK_B_PRECS = 4;
    private static final int PACK_B_PREFIX = 8;
    private static final int G_EXTBIT = 128;
    private static final int G_SIGNBIT = 64;
    private static final int G_COUNTMASK = 56;
    private static final int G_SEEDMASK = 7;
    private static final int EXT_INSENSE = 1;
    private static final int EXT_REVERSE = 2;
    public static final int DBL_DIG = 15;
    private static final char[] PACK_TEXT = new char[]{'d', 't', 'i', 'f', 's', 'c', 'm', 'p', 'w', 'a', 'j', 'e', 'u', '!', '?'};
    private static final String PACK_FLAGS = "0 -+*";
    private Charset currentCharset = Charset.defaultCharset();
    static final int[] flagvals = new int[]{1, 2, 4, 8, 16, 64};
    char[] value;
    int count;
    private static final DomainString NULL = new DomainString("null");
    static PrintfFormat format = null;
    DomainString packResultString;
    DomainString tempString2;
    DomainString unpackTempString;

    public DomainString() {
        this(32);
    }

    public DomainString(int length) {
        this.value = new char[length];
    }

    public DomainString(String str) {
        this(str.length() + 32);
        this.append(str);
    }

    public DomainString(DomainString str) {
        this(str, str.value.length);
        this.currentCharset = str.currentCharset;
    }

    private DomainString(DomainString str, int length) {
        this(length);
        this.currentCharset = str.currentCharset;
        this.append(str.value, 0, str.count);
    }

    public DomainString(DomainFixedString str) {
        this(str.toString());
    }

    public DomainString(DomainString[] a, int i2) {
        this();
        this.DVArray = a;
        this.DVIndex = i2;
    }

    public DomainString(char[] arr, int offset, int len) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        if (offset > arr.length - len) {
            throw new StringIndexOutOfBoundsException(offset + len);
        }
        this.value = new char[len + 32];
        this.count = len;
        System.arraycopy(arr, offset, this.value, 0, len);
    }

    public DomainString(byte[] arr, int offset, int len) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        if (offset > arr.length - len) {
            throw new StringIndexOutOfBoundsException(offset + len);
        }
        this.value = new char[len + 32];
        int i2 = this.count = len;
        while (i2-- > 0) {
            this.value[i2] = (char)(arr[i2 + offset] & 0xFF);
        }
    }

    public DomainString(DomainByteArrayFileMap arr, int offset, int len) {
        this(arr.getBytes(offset, len), 0, len);
    }

    public int length() {
        return this.count;
    }

    public static int length(String s) {
        return s.length();
    }

    public static int length(DomainString s) {
        return s.count;
    }

    int capacity() {
        return this.value.length;
    }

    @Override
    public void reset() {
        if (this.count > 0) {
            this.count = 0;
        }
    }

    void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        if (this.count > 0) {
            System.arraycopy(this.value, 0, newValue, 0, this.count);
        }
        this.value = newValue;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public char[] toCharArray() {
        char[] result = new char[this.count];
        this.getChars(0, this.count, result, 0);
        return result;
    }

    void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public byte[] toByteArray() {
        int i2 = 0;
        byte[] byteArr = new byte[this.count];
        while (i2 < this.count) {
            byteArr[i2] = (byte)this.value[i2++];
        }
        return byteArr;
    }

    void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public DomainString append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public DomainString append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public void encode(String charsetName) {
        try {
            Charset cs;
            this.currentCharset = cs = Charset.forName(charsetName);
            ByteBuffer bb = cs.encode(this.toString());
            byte[] arr = new byte[bb.remaining()];
            bb.get(arr);
            for (int i2 = 0; i2 < arr.length; ++i2) {
                this.value[i2] = (char)arr[i2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void decode(String charsetName) {
        try {
            Charset cs;
            this.currentCharset = cs = Charset.forName(charsetName);
            CharBuffer cb = cs.decode(ByteBuffer.wrap(this.toByteArray()));
            char[] arr = new char[cb.length()];
            cb.get(arr);
            this.setValue(new String(arr));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DomainString append(DomainString sb) {
        int len;
        int newcount;
        if (sb == null) {
            sb = NULL;
        }
        if ((newcount = this.count + (len = sb.count)) > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public DomainString append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    DomainString append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (len > 0 && offset < str.length) {
            if (newcount > this.value.length) {
                this.expandCapacity(newcount);
            }
            System.arraycopy(str, offset, this.value, this.count, len);
            this.count = newcount;
        }
        return this;
    }

    DomainString append(byte[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    DomainString append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public int delete(int start, int len) {
        int end = start + len;
        if (start >= 0 && this.count >= 0 && start + len <= this.count) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
            return 1;
        }
        return 0;
    }

    public int delete(int start, DomainInteger len) {
        return this.delete(start, len.value);
    }

    public int delete(DomainInteger start, int len) {
        return this.delete(start.value, len);
    }

    DomainString deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public DomainString replace(int start, int end, String str) {
        return this.replace(start, end, str.toCharArray(), str.length());
    }

    public DomainString replace(int start, int end, DomainString str) {
        return this.replace(start, end, str.value, str.count);
    }

    private DomainString replace(int start, int end, char[] buffer, int len) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int newCount = this.count + len - (end - start);
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        System.arraycopy(buffer, 0, this.value, start, len);
        this.count = newCount;
        return this;
    }

    public DomainString substring(int start) {
        return this.substring(start, this.count - start);
    }

    public DomainString substring(DomainInteger start) {
        return this.substring(start.value, this.count - start.value);
    }

    public DomainString substring(int start, int length) {
        if (start >= 0 && start < this.count && this.count >= 0 && start + length <= this.count && length >= 0) {
            if (length == 0) {
                return new DomainString();
            }
            return new DomainString(this.value, start, length);
        }
        return new DomainString();
    }

    public DomainString substring(int start, DomainInteger length) {
        return this.substring(start, length.value);
    }

    public DomainString substring(DomainInteger start, int length) {
        return this.substring(start.value, length);
    }

    public DomainString substring(DomainInteger start, DomainInteger length) {
        return this.substring(start.value, length.value);
    }

    public DomainString insert(int index, char[] buffer, int offset, int len) {
        if (index < 0 || index > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset < 0 || offset + len < 0 || offset + len > buffer.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(buffer, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public int insert(int offset, String str) {
        try {
            this.insert(offset, str.toCharArray(), str.length());
            return 1;
        }
        catch (IndexOutOfBoundsException ex) {
            return 0;
        }
    }

    public int insert(DomainInteger offset, String str) {
        return this.insert(offset.value, str);
    }

    public int insert(int offset, DomainString str) {
        try {
            this.insert(offset, str.value, str.count);
            return 1;
        }
        catch (IndexOutOfBoundsException ex) {
            return 0;
        }
    }

    public int insert(DomainInteger offset, DomainString str) {
        return this.insert(offset.value, str);
    }

    public DomainString insert(int offset, char[] buffer, int len) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(buffer, 0, this.value, offset, len);
        this.count = newcount;
        return this;
    }

    DomainString insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
        return this;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(DomainString str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return DomainString.indexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int indexOf(DomainString str, int fromIndex) {
        return DomainString.indexOf(this.value, 0, this.count, str.value, 0, str.count, fromIndex);
    }

    public static int indexOf(String s, String sub, DomainInteger position) {
        return DomainString.indexOf(s.toCharArray(), 0, s.length(), sub.toCharArray(), 0, sub.length(), 0, position);
    }

    public static int indexOf(String s, DomainString sub, DomainInteger position) {
        return DomainString.indexOf(s.toCharArray(), 0, s.length(), sub.value, 0, sub.count, 0, position);
    }

    public static int indexOf(DomainString s, String sub, DomainInteger position) {
        return DomainString.indexOf(s.value, 0, s.count, sub.toCharArray(), 0, sub.length(), 0, position);
    }

    public static int indexOf(DomainString s, DomainString sub, DomainInteger position) {
        return DomainString.indexOf(s.value, 0, s.count, sub.value, 0, sub.count, 0, position);
    }

    public static int indexOfI(String s, String sub, DomainInteger position) {
        return DomainString.indexOf(s.toLowerCase().toCharArray(), 0, s.length(), sub.toLowerCase().toCharArray(), 0, sub.length(), 0, position);
    }

    public static int indexOfI(String s, DomainString sub, DomainInteger position) {
        return DomainString.indexOf(s.toLowerCase().toCharArray(), 0, s.length(), DomainString.toLowerCaseC((DomainString)sub).value, 0, sub.count, 0, position);
    }

    public static int indexOfI(DomainString s, String sub, DomainInteger position) {
        return DomainString.indexOf(DomainString.toLowerCaseC((DomainString)s).value, 0, s.count, sub.toLowerCase().toCharArray(), 0, sub.length(), 0, position);
    }

    public static int indexOfI(DomainString s, DomainString sub, DomainInteger position) {
        return DomainString.indexOf(DomainString.toLowerCaseC((DomainString)s).value, 0, s.count, DomainString.toLowerCaseC((DomainString)sub).value, 0, sub.count, 0, position);
    }

    private static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex, DomainInteger position) {
        int pos = DomainString.indexOf(source, sourceOffset, sourceCount, target, targetOffset, targetCount, fromIndex);
        if (pos == -1) {
            return 0;
        }
        position.setValue(pos);
        return 1;
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount || targetCount == 0) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        char first = target[targetOffset];
        int i2 = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i2 <= max && source[i2] != first) {
                ++i2;
                continue;
            }
            if (i2 > max) {
                return -1;
            }
            int j = i2 + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (source[j++] == target[k++]) continue;
                ++i2;
                continue block0;
            }
            break;
        }
        return i2 - sourceOffset;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, str.length());
    }

    public int lastIndexOf(DomainString str) {
        return this.lastIndexOf(str, str.length());
    }

    public int lastIndexOf(String str, int fromIndex) {
        return DomainString.lastIndexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int lastIndexOf(DomainString str, int fromIndex) {
        return DomainString.lastIndexOf(this.value, 0, this.count, str.value, 0, str.count, fromIndex);
    }

    public static int lastIndexOf(String s, String sub, DomainInteger position) {
        return DomainString.lastIndexOf(s.toCharArray(), 0, s.length(), sub.toCharArray(), 0, sub.length(), s.length(), position);
    }

    public static int lastIndexOf(String s, DomainString sub, DomainInteger position) {
        return DomainString.lastIndexOf(s.toCharArray(), 0, s.length(), sub.value, 0, sub.count, s.length(), position);
    }

    public static int lastIndexOf(DomainString s, String sub, DomainInteger position) {
        return DomainString.lastIndexOf(s.value, 0, s.count, sub.toCharArray(), 0, sub.length(), s.count, position);
    }

    public static int lastIndexOf(DomainString s, DomainString sub, DomainInteger position) {
        return DomainString.lastIndexOf(s.value, 0, s.count, sub.value, 0, sub.count, s.count, position);
    }

    public static int lastIndexOfI(String s, String sub, DomainInteger position) {
        return DomainString.lastIndexOf(s.toLowerCase().toCharArray(), 0, s.length(), sub.toLowerCase().toCharArray(), 0, sub.length(), s.length(), position);
    }

    public static int lastIndexOfI(String s, DomainString sub, DomainInteger position) {
        return DomainString.lastIndexOf(s.toLowerCase().toCharArray(), 0, s.length(), DomainString.toLowerCaseC((DomainString)sub).value, 0, sub.count, s.length(), position);
    }

    public static int lastIndexOfI(DomainString s, String sub, DomainInteger position) {
        return DomainString.lastIndexOf(DomainString.toLowerCaseC((DomainString)s).value, 0, s.count, sub.toLowerCase().toCharArray(), 0, sub.length(), s.count, position);
    }

    public static int lastIndexOfI(DomainString s, DomainString sub, DomainInteger position) {
        return DomainString.lastIndexOf(DomainString.toLowerCaseC((DomainString)s).value, 0, s.count, DomainString.toLowerCaseC((DomainString)sub).value, 0, sub.count, s.count, position);
    }

    private static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex, DomainInteger position) {
        int pos = DomainString.lastIndexOf(source, sourceOffset, sourceCount, target, targetOffset, targetCount, fromIndex);
        if (pos == -1) {
            return 0;
        }
        position.setValue(pos);
        return 1;
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return -1;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i2 = min + fromIndex;
        block0: while (true) {
            if (i2 >= min && source[i2] != strLastChar) {
                --i2;
                continue;
            }
            if (i2 < min) {
                return -1;
            }
            int j = i2 - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i2;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.count;
        char[] v = this.value;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.count) {
            return -1;
        }
        for (int i2 = fromIndex; i2 < max; ++i2) {
            if (v[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public String getValue() {
        return this.toString();
    }

    public DomainString setValue(String str) {
        this.count = 0;
        this.append(str);
        return this;
    }

    public DomainString setValue(DomainString str) {
        if (this != str) {
            this.count = 0;
            this.append(str);
        }
        return this;
    }

    @Override
    public DomainVariable setValue(DomainVariable v) {
        this.setValue(v.toString());
        return this;
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, String str) {
        _env.LastError.reset();
        if (str == null || str.length() <= 0) {
            this.reset();
            return this;
        }
        return this.setValue(str);
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, DomainString str) {
        _env.LastError.reset();
        if (str == null || str.count <= 0) {
            this.reset();
            return this;
        }
        return this.setValue(str);
    }

    DomainVariable setValue(DomainString str, int start) {
        return this.setValue(str, start, str.count - start);
    }

    DomainVariable setValue(DomainString str, int start, int len) {
        this.count = 0;
        this.append(str.value, start, len);
        return this;
    }

    public DomainVariable setValue(char[] buffer, int start, int len) {
        this.count = 0;
        this.append(buffer, start, len);
        return this;
    }

    public DomainVariable setValue(byte[] buffer, int start, int len) {
        if (len > this.value.length) {
            this.expandCapacity(len);
        }
        int i2 = len;
        while (i2-- > 0) {
            this.value[i2] = (char)(buffer[i2 + start] & 0xFF);
        }
        this.count = len;
        return this;
    }

    public DomainVariable setValue(DomainByteArrayFileMap buffer, int start, int len) {
        if (len > this.value.length) {
            this.expandCapacity(len);
        }
        int i2 = len;
        while (i2-- > 0) {
            this.value[i2] = (char)(buffer.getByte(i2 + start) & 0xFF);
        }
        this.count = len;
        return this;
    }

    public DomainVariable setValue(Object[] objectArray) {
        StringBuffer sb = new StringBuffer("{");
        for (int l = 0; l < objectArray.length; ++l) {
            if (objectArray[l] instanceof String || objectArray[l] instanceof DomainString || objectArray[l] instanceof DomainFixedString) {
                sb.append("\"" + objectArray[l].toString() + "\",");
                continue;
            }
            sb.append(objectArray[l].toString() + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        this.setValue(sb.toString());
        return this;
    }

    public DomainVariable setValue(double[] doubleArray) {
        StringBuffer sb = new StringBuffer("{");
        for (int l = 0; l < doubleArray.length; ++l) {
            sb.append(doubleArray[l] + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        this.setValue(sb.toString());
        return this;
    }

    public DomainVariable setValue(int[] intArray) {
        StringBuffer sb = new StringBuffer("{");
        for (int l = 0; l < intArray.length; ++l) {
            sb.append(intArray[l] + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        this.setValue(sb.toString());
        return this;
    }

    public int hashCode() {
        int h = 0;
        int off = 0;
        for (int i2 = 0; i2 < this.count; ++i2) {
            h = 31 * h + this.value[off++];
        }
        return h;
    }

    public boolean equals(Object anObject) {
        String anotherString;
        int n;
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof DomainString) {
            DomainString anotherString2 = (DomainString)anObject;
            int n2 = this.count;
            if (n2 == anotherString2.count) {
                char[] v1 = this.value;
                char[] v2 = anotherString2.value;
                int i2 = 0;
                int j = 0;
                while (n2-- != 0) {
                    if (v1[i2++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        } else if (anObject instanceof String && (n = this.count) == (anotherString = (String)anObject).length()) {
            char[] v1 = this.value;
            char[] v2 = anotherString.toCharArray();
            int i3 = 0;
            int j = 0;
            while (n-- != 0) {
                if ((v1[i3++] & 0xFF) == (v2[j++] & 0xFF)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.compareTo((DomainString)o);
    }

    public int compareTo(String s) {
        return this.compareTo(s.toCharArray(), s.length());
    }

    public int compareTo(DomainString s) {
        return this.compareTo(s.value, s.count);
    }

    private int compareTo(char[] arr, int arrLen) {
        int len1 = this.count;
        int len2 = arrLen;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = arr;
        int i2 = 0;
        int j = 0;
        if (i2 == j) {
            int lim = n + i2;
            for (int k = i2; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                char c2;
                char c1;
                if ((c1 = v1[i2++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public int truncate(int index) {
        if (index < 0 || index > this.count) {
            return 0;
        }
        this.delete(index, this.count - index);
        return 1;
    }

    public int truncate(DomainInteger index) {
        return this.truncate(index.value);
    }

    public static DomainString substring(String s, int start, int count) {
        return new DomainString(s).substring(start, count);
    }

    public void toUpperCase() {
        if (this.count > 0) {
            String upperStr = new String(this.value).toUpperCase();
            System.arraycopy(upperStr.toCharArray(), 0, this.value, 0, this.count);
        }
    }

    public static DomainString toUpperCaseC(String str) {
        return new DomainString(str.toUpperCase());
    }

    public static DomainString toUpperCaseC(DomainString str) {
        DomainString newStr = new DomainString(str);
        newStr.toUpperCase();
        return newStr;
    }

    public void toLowerCase() {
        if (this.count > 0) {
            String lowerStr = new String(this.value).toLowerCase();
            System.arraycopy(lowerStr.toCharArray(), 0, this.value, 0, this.count);
        }
    }

    public static DomainString toLowerCaseC(String str) {
        return new DomainString(str.toLowerCase());
    }

    public static DomainString toLowerCaseC(DomainString str) {
        DomainString newStr = new DomainString(str);
        newStr.toLowerCase();
        return newStr;
    }

    public void toProperCase() {
        this.toLowerCase();
        if (this.count > 0) {
            this.setCharAt(0, Character.toUpperCase(this.charAt(0)));
        }
    }

    public static DomainString toProperCaseC(String str) {
        DomainString newStr = new DomainString(str);
        newStr.toProperCase();
        return newStr;
    }

    public static DomainString toProperCaseC(DomainString str) {
        DomainString newStr = new DomainString(str);
        newStr.toProperCase();
        return newStr;
    }

    public static boolean ispunct(char ch) {
        return ch > ' ' && ch < '~' && !Character.isSpaceChar(ch) && !Character.isLetterOrDigit(ch);
    }

    public DomainString trim() {
        int st;
        int len = this.count;
        int off = 0;
        for (st = 0; st < len && this.value[off + st] <= ' '; ++st) {
        }
        while (st < len && this.value[off + len - 1] <= ' ') {
            --len;
        }
        if (st > 0 || len < this.count) {
            char[] temp = this.value;
            this.count = len - st;
            this.value = new char[this.count + 32];
            System.arraycopy(temp, st, this.value, 0, this.count);
        }
        return this;
    }

    public static DomainString trimLeftC(String src, String pattern) {
        DomainString temp = new DomainString(src);
        temp.trimLeft(pattern);
        return temp;
    }

    public static DomainString trimLeftC(DomainString src, String pattern) {
        DomainString temp = new DomainString(src);
        temp.trimLeft(pattern);
        return temp;
    }

    public static DomainString trimLeftC(DomainFixedString src, String pattern) {
        DomainString temp = new DomainString(src);
        temp.trimLeft(pattern);
        return temp;
    }

    public int trimLeft(String pattern) {
        return this.trimLeft(pattern.toCharArray(), pattern.length());
    }

    public int trimLeft(DomainString pattern) {
        return this.trimLeft(pattern.value, pattern.count);
    }

    private int trimLeft(char[] buffer, int len) {
        int numTrimmed = 0;
        if (buffer != null && len > 0) {
            boolean match = true;
            while (this.count - numTrimmed >= len) {
                for (int i2 = 0; i2 < len; ++i2) {
                    if (this.value[numTrimmed + i2] == buffer[i2]) continue;
                    match = false;
                    break;
                }
                if (!match) break;
                numTrimmed += len;
            }
            if (numTrimmed != 0) {
                this.delete(0, numTrimmed);
            }
        }
        return numTrimmed;
    }

    public static DomainString trimRightC(String src, String pattern) {
        DomainString temp = new DomainString(src);
        temp.trimLeft(pattern);
        return temp;
    }

    public static DomainString trimRightC(DomainString src, String pattern) {
        DomainString temp = new DomainString(src);
        temp.trimRight(pattern);
        return temp;
    }

    public static DomainString trimRightC(DomainFixedString src, String pattern) {
        DomainString temp = new DomainString(src);
        temp.trimRight(pattern);
        return temp;
    }

    public int trimRight(String pattern) {
        int len = pattern.length();
        if (len == 1) {
            return this.trimRight(pattern.charAt(0));
        }
        return this.trimRight(pattern.toCharArray(), len);
    }

    public int trimRight(DomainString pattern) {
        return this.trimRight(pattern.value, pattern.count);
    }

    private int trimRight(char ch) {
        int numTrimmed = 0;
        if (this.count > 0 && ch != '\u0000') {
            boolean match = true;
            while (this.count > 0 && this.value[this.count - 1] == ch) {
                --this.count;
                ++numTrimmed;
            }
        }
        return numTrimmed;
    }

    private int trimRight(char[] buffer, int len) {
        int numTrimmed = 0;
        if (buffer != null && len > 0) {
            boolean match = true;
            while (this.count >= len) {
                int i2 = this.count - 1;
                int j = len - 1;
                while (i2 > this.count - 1 - len) {
                    if (this.value[i2] != buffer[j]) {
                        match = false;
                        break;
                    }
                    --i2;
                    --j;
                }
                if (!match) break;
                this.count -= len;
                numTrimmed += len;
            }
        }
        return numTrimmed;
    }

    public int replace(String search, String replace, int fromIndex, int flag) {
        return this.replace(search.toCharArray(), search.length(), replace.toCharArray(), replace.length(), fromIndex, flag);
    }

    public int replace(String search, String replace, int fromIndex, DomainInteger flag) {
        return this.replace(search.toCharArray(), search.length(), replace.toCharArray(), replace.length(), fromIndex, flag.value);
    }

    public int replace(String search, String replace, DomainInteger fromIndex, int flag) {
        return this.replace(search.toCharArray(), search.length(), replace.toCharArray(), replace.length(), fromIndex.value, flag);
    }

    public int replace(String search, DomainString replace, int fromIndex, int flag) {
        return this.replace(search.toCharArray(), search.length(), replace.value, replace.count, fromIndex, flag);
    }

    public int replace(String search, DomainString replace, int fromIndex, DomainInteger flag) {
        return this.replace(search.toCharArray(), search.length(), replace.value, replace.count, fromIndex, flag.value);
    }

    public int replace(String search, DomainString replace, DomainInteger fromIndex, int flag) {
        return this.replace(search.toCharArray(), search.length(), replace.value, replace.count, fromIndex.value, flag);
    }

    public int replace(DomainString search, String replace, int fromIndex, int flag) {
        return this.replace(search.value, search.count, replace.toCharArray(), replace.length(), fromIndex, flag);
    }

    public int replace(DomainString search, String replace, int fromIndex, DomainInteger flag) {
        return this.replace(search.value, search.count, replace.toCharArray(), replace.length(), fromIndex, flag.value);
    }

    public int replace(DomainString search, String replace, DomainInteger fromIndex, int flag) {
        return this.replace(search.value, search.count, replace.toCharArray(), replace.length(), fromIndex.value, flag);
    }

    public int replace(DomainString search, DomainString replace, int fromIndex, int flag) {
        return this.replace(search.value, search.count, replace.value, replace.count, fromIndex, flag);
    }

    public int replace(DomainString search, DomainString replace, int fromIndex, DomainInteger flag) {
        return this.replace(search.value, search.count, replace.value, replace.count, fromIndex, flag.value);
    }

    public int replace(DomainString search, DomainString replace, DomainInteger fromIndex, int flag) {
        return this.replace(search.value, search.count, replace.value, replace.count, fromIndex.value, flag);
    }

    private int replace(char[] search, int searchCount, char[] replace, int replaceCount, int fromIndex, int flag) {
        int num = 0;
        int index = 0;
        boolean next = false;
        if (this.count == 0) {
            return 0;
        }
        if (search == null || searchCount == 0) {
            return 0;
        }
        if (fromIndex < 0) {
            return 0;
        }
        switch (flag) {
            default: {
                index = DomainString.indexOf(this.value, 0, this.count, search, 0, searchCount, fromIndex);
                while (index >= 0) {
                    this.replace(index, index + searchCount, replace, replaceCount);
                    fromIndex = index + replaceCount;
                    index = DomainString.indexOf(this.value, 0, this.count, search, 0, searchCount, fromIndex);
                    ++num;
                }
                break;
            }
            case 1: {
                index = DomainString.indexOf(this.value, 0, this.count, search, 0, searchCount, fromIndex);
                if (index < 0) break;
                this.replace(index, index + searchCount, replace, replaceCount);
                ++num;
                break;
            }
            case 2: {
                if (fromIndex > this.count) {
                    index = -1;
                    break;
                }
                index = DomainString.lastIndexOf(this.value, 0, this.count, search, 0, searchCount, this.count);
                if (index < 0) break;
                this.replace(index, index + searchCount, replace, replaceCount);
                ++num;
            }
        }
        return num;
    }

    public DomainString modify(String command) {
        return this.modify(command.toCharArray(), command.length());
    }

    public DomainString modify(DomainString command) {
        return this.modify(command.value, command.count);
    }

    private DomainString modify(char[] buffer, int bufLen) {
        int strIndex = 0;
        boolean found = false;
        int bufIndex = 0;
        int begin = 0;
        int end = 0;
        boolean insert = false;
        block13: while (bufIndex < bufLen) {
            switch (buffer[bufIndex++]) {
                case '{': {
                    int num;
                    begin = bufIndex;
                    while (bufIndex < bufLen && buffer[bufIndex] != '}') {
                        ++bufIndex;
                    }
                    if (this.count >= strIndex + (num = DomainInteger.parseInt(buffer, begin, end = bufIndex++, 10))) {
                        found = true;
                        strIndex += num;
                    } else {
                        found = false;
                        strIndex = this.count;
                    }
                    if (strIndex >= 0) continue block13;
                    strIndex = 0;
                    continue block13;
                }
                case '[': {
                    begin = bufIndex;
                    while (bufIndex < bufLen && buffer[bufIndex] != ']') {
                        ++bufIndex;
                    }
                    end = bufIndex++;
                    String searchStr = new String(buffer, begin, end - begin);
                    if ((begin = DomainString.indexOf(this.value, 0, this.count, buffer, begin, end - begin, 0)) < 0) continue block13;
                    strIndex = begin;
                    found = true;
                    continue block13;
                }
                case '?': {
                    if (found) continue block13;
                    while (bufIndex < bufLen && buffer[bufIndex] != ')') {
                        ++bufIndex;
                    }
                    ++bufIndex;
                    continue block13;
                }
                case '(': {
                    continue block13;
                }
                case ')': {
                    if (!found || buffer[bufIndex] != '(') continue block13;
                    while (bufIndex < bufLen && buffer[bufIndex] != ')') {
                        ++bufIndex;
                    }
                    ++bufIndex;
                    continue block13;
                }
                case '^': {
                    insert = !insert;
                    continue block13;
                }
                case '*': {
                    if (strIndex >= this.count) continue block13;
                    ++strIndex;
                    continue block13;
                }
                case '$': {
                    strIndex = this.count;
                    continue block13;
                }
                case '~': {
                    this.delete(strIndex, 1);
                    continue block13;
                }
                case '#': {
                    if (strIndex <= 0) continue block13;
                    this.delete(0, strIndex);
                    strIndex = 0;
                    continue block13;
                }
                default: {
                    --bufIndex;
                }
                case '\\': 
            }
            if (insert || strIndex >= this.count) {
                this.insert(strIndex, buffer[bufIndex]);
            } else {
                this.setCharAt(strIndex, buffer[bufIndex]);
            }
            ++bufIndex;
            ++strIndex;
        }
        return this.substring(0, strIndex);
    }

    public static synchronized DomainString format(DomainEnvironment env, String command, Object[] objs) throws DomainInvalidCodeException {
        if (format == null) {
            format = new PrintfFormat();
        }
        format.setFormatArgs(command);
        return format.sprintf(env, objs);
    }

    private static String repeat(char ch, int width) {
        char[] chArr = new char[width];
        Arrays.fill(chArr, ch);
        return new String(chArr, 0, width);
    }

    public int pack(DomainEnvironment env, String format, Object[] objs) {
        String defTime;
        String defDate;
        int arrLen = 0;
        int arrIndex = 0;
        int fmtIndex = 0;
        int width = 0;
        int precision = 0;
        int argCount = 0;
        int state = 0;
        int delim = 0;
        int defWidth = 0;
        String tempString = null;
        if (this.packResultString == null) {
            this.packResultString = new DomainString();
            this.tempString2 = new DomainString();
        } else {
            this.packResultString.reset();
            this.tempString2.reset();
        }
        Object obj = null;
        char[] ch = format.toCharArray();
        String lastCurrStr = null;
        double lastDbl = 0.0;
        boolean isArray = false;
        String curDate = defDate = env.getDateOutFormat();
        String curTime = defTime = env.getTimeOutFormat();
        env.LastError.setValue(0);
        PackToken packToken = new PackToken();
        block30: while (true) {
            fmtIndex = packToken.GetPackToken(ch, fmtIndex);
            if ((packToken.flag & 0x10) != 0) {
                if ((width = ((DomainInteger)objs[argCount++]).getValue()) > 0) {
                    packToken.width = width;
                } else {
                    env.LastError.setValue(7);
                }
            }
            if ((packToken.flag & 0x20) != 0) {
                if ((precision = ((DomainInteger)objs[argCount++]).getValue()) > 0) {
                    packToken.precision = precision;
                } else {
                    env.LastError.setValue(7);
                }
            }
            switch (packToken.token) {
                case '!': {
                    if (fmtIndex != ch.length) {
                        env.LastError.setValue(1);
                    }
                    if (state == 1 && this.packResultString.length() > 0) {
                        this.packResultString.deleteCharAt(this.packResultString.length() - 1);
                    }
                    this.value = new char[this.packResultString.count + 32];
                    System.arraycopy(this.packResultString.value, 0, this.value, 0, this.packResultString.count);
                    this.count = this.packResultString.count;
                    return 0;
                }
                case '?': {
                    continue block30;
                }
                case 'a': {
                    arrLen = packToken.width;
                    arrIndex = 0;
                    isArray = true;
                    continue block30;
                }
                case 'p': {
                    state = 1;
                    delim = packToken.width;
                    continue block30;
                }
                case 'w': {
                    state = 0;
                    defWidth = packToken.width;
                    continue block30;
                }
                case 'j': {
                    break;
                }
                case 'd': {
                    curDate = !packToken.prefix.equals("") ? packToken.prefix : defDate;
                    break;
                }
                case 't': {
                    curTime = !packToken.prefix.equals("") ? packToken.prefix : defTime;
                    break;
                }
                case 'e': {
                    defDate = !packToken.prefix.equals("") ? packToken.prefix : env.getDateOutFormat();
                    continue block30;
                }
                case 'u': {
                    defTime = !packToken.prefix.equals("") ? packToken.prefix : env.getTimeOutFormat();
                    continue block30;
                }
            }
            block31: do {
                if (arrLen > 0 && isArray) {
                    obj = ((Object[])objs[argCount])[arrIndex++];
                    if (--arrLen == 0) {
                        isArray = false;
                        ++argCount;
                    }
                } else {
                    if (isArray) {
                        isArray = false;
                        ++argCount;
                        continue;
                    }
                    if (packToken.token != 'j') {
                        obj = objs[argCount];
                        ++argCount;
                    }
                }
                String flag = "";
                if ((packToken.flag & 1) == 1) {
                    flag = "0";
                } else if ((packToken.flag & 4) == 4 || packToken.token == 's' && packToken.flag == 0) {
                    flag = "-";
                }
                if ((packToken.flag & 0x40) == 64 && width > 0) {
                    ++width;
                }
                switch (state) {
                    case 0: {
                        width = packToken.width == 0 ? defWidth : packToken.width;
                        break;
                    }
                    case 1: {
                        width = 0;
                    }
                }
                switch (packToken.token) {
                    case 'j': {
                        tempString = DomainString.repeat(' ', width);
                        break;
                    }
                    case 'd': {
                        if (obj instanceof DomainExtDate) {
                            tempString = ((DomainExtDate)obj).toString(curDate);
                            break;
                        }
                        tempString = ((DomainDate)obj).toString(curDate);
                        break;
                    }
                    case 't': {
                        if (obj instanceof DomainExtDate) {
                            tempString = ((DomainExtDate)obj).toString(curTime);
                            break;
                        }
                        tempString = ((DomainDate)obj).toString(curTime);
                        break;
                    }
                    case 'c': {
                        if (((DomainCode)obj).getEntry() != null) {
                            tempString = ((DomainCode)obj).getEntry().getName().toString();
                            if (packToken.prefix == null || packToken.prefix.length() <= 0 || tempString.indexOf(packToken.prefix) != 0) break;
                            tempString = tempString.substring(packToken.prefix.length());
                            break;
                        }
                        tempString = "";
                        break;
                    }
                    case 'm': {
                        int begin;
                        String currStr;
                        double dblValue = ((DomainCurrency)obj).value;
                        if ((packToken.flag & 2) == 2 && dblValue == 0.0) {
                            tempString = DomainString.repeat(' ', width);
                            break;
                        }
                        if (dblValue == 0.0) {
                            currStr = "0.00";
                        } else {
                            double round = DomainFloat.round(dblValue, 2);
                            currStr = round == lastDbl ? lastCurrStr : DomainCurrency.strfmon(env.getCurrencyOutFormat(), round);
                            lastDbl = round;
                            lastCurrStr = currStr;
                        }
                        tempString = currStr;
                        if (width == 0) break;
                        if (width > tempString.length()) {
                            char aChar = ' ';
                            if ((packToken.flag & 1) == 1) {
                                aChar = '0';
                            }
                            this.tempString2.setValue(tempString);
                            int len = this.tempString2.count;
                            int pos = (packToken.flag & 1) == 1 ? (this.tempString2.charAt(0) == '-' ? 1 : (this.tempString2.charAt(0) == '(' ? 1 : 0)) : ((packToken.flag & 4) == 4 ? len : 0);
                            for (int i2 = 0; i2 < width - len; ++i2) {
                                this.tempString2.insert(pos, aChar);
                            }
                            tempString = this.tempString2.toString();
                        } else if (tempString.length() > width) {
                            tempString = tempString.substring(0, width);
                        }
                        if ((packToken.flag & 0x40) != 64 || (begin = tempString.indexOf(46)) <= 0) break;
                        tempString = tempString.substring(0, begin) + tempString.substring(begin + 1);
                        break;
                    }
                    case 'f': {
                        int begin;
                        if ((packToken.flag & 2) == 2 && ((DomainFloat)obj).value == 0.0) {
                            tempString = DomainString.repeat(' ', width);
                            break;
                        }
                        precision = 0;
                        char type = 'f';
                        if (packToken.precision == 0) {
                            precision = DomainString.getFloatPrecision(obj.toString());
                            type = 'g';
                        } else {
                            type = 'f';
                            precision = packToken.precision;
                        }
                        String fmtString = "%" + flag + width + "." + precision + type;
                        tempString = DomainString.format(env, fmtString, new Object[]{obj}).toString();
                        if ((packToken.flag & 0x40) != 64 || (begin = tempString.indexOf(46)) <= 0) break;
                        tempString = tempString.substring(0, begin) + tempString.substring(begin + 1);
                        break;
                    }
                    case 'i': {
                        if ((packToken.flag & 2) == 2 && ((DomainInteger)obj).value == 0) {
                            tempString = DomainString.repeat(' ', width);
                            break;
                        }
                        this.tempString2.setValue(obj.toString());
                        if (width > this.tempString2.count) {
                            if ((packToken.flag & 1) == 1) {
                                int len = this.tempString2.count;
                                int index = this.tempString2.charAt(0) == '-' ? 1 : 0;
                                for (int i3 = 0; i3 < width - len; ++i3) {
                                    this.tempString2.insert(index, "0");
                                }
                            } else if ((packToken.flag & 4) == 4) {
                                int len = this.tempString2.count;
                                for (int i4 = width; i4 > len; --i4) {
                                    this.tempString2.append(' ');
                                }
                            } else {
                                int len = this.tempString2.count;
                                for (int i5 = width; i5 > len; --i5) {
                                    this.tempString2.insert(0, ' ');
                                }
                            }
                        }
                        tempString = this.tempString2.toString();
                        break;
                    }
                    case 's': {
                        if (width > obj.toString().length()) {
                            if (obj instanceof DomainString) {
                                int index;
                                DomainString objS = (DomainString)obj;
                                char[] chArr = new char[width];
                                for (index = 0; index < objS.length(); ++index) {
                                    chArr[index] = objS.charAt(index);
                                }
                                Arrays.fill(chArr, index, width, ' ');
                                tempString = new String(chArr);
                                break;
                            }
                            if (!(obj instanceof DomainFixedString)) break;
                            tempString = new DomainFixedString(width, (DomainFixedString)obj).toString();
                            break;
                        }
                        tempString = obj.toString();
                    }
                }
                switch (state) {
                    case 0: {
                        if (width <= 0) break;
                        int len = tempString.length();
                        this.packResultString.append(tempString.substring(0, Math.min(len, width)));
                        if (width <= len) continue block31;
                        if (this.packResultString.value.length < this.packResultString.count + width) {
                            this.packResultString.expandCapacity(width - len);
                        }
                        Arrays.fill(this.packResultString.value, this.packResultString.count, this.packResultString.count + (width - len), ' ');
                        this.packResultString.count += width - len;
                        break;
                    }
                    case 1: {
                        boolean quote;
                        boolean emptyField = false;
                        boolean bl = quote = tempString.startsWith(" ") || tempString.endsWith(" ") || tempString.indexOf((char)delim) >= 0 || tempString.indexOf(34) >= 0;
                        if ((packToken.flag & 8) != 0) {
                            quote = false;
                            if (tempString.length() == 0) {
                                emptyField = true;
                            }
                        }
                        boolean bl2 = quote = quote && (packToken.flag & 8) != 8;
                        if (tempString.indexOf(34) != -1) {
                            tempString = tempString.replaceAll("\"", "\"\"");
                        }
                        if (quote) {
                            this.packResultString.append("\"");
                        }
                        this.packResultString.append(tempString);
                        if (quote) {
                            this.packResultString.append("\"");
                        }
                        if (emptyField) break;
                        this.packResultString.append((char)delim);
                    }
                }
            } while (arrLen > 0);
        }
    }

    private static int getFloatPrecision(String sx) {
        int expon = 0;
        int ePos = sx.indexOf(69);
        int rPos = sx.indexOf(46);
        int sxLen = sx.length();
        if (ePos != -1) {
            int rVal;
            int ie = ePos + 1;
            expon = 0;
            if (sx.charAt(ie) == '-') {
                ++ie;
                while (ie < sxLen && sx.charAt(ie) == '0') {
                    ++ie;
                }
                if (ie < sxLen) {
                    expon = -Integer.parseInt(sx.substring(ie));
                }
            } else {
                if (sx.charAt(ie) == '+') {
                    ++ie;
                }
                while (ie < sxLen && sx.charAt(ie) == '0') {
                    ++ie;
                }
                if (ie < sxLen) {
                    expon = Integer.parseInt(sx.substring(ie));
                }
            }
            return (rVal = ePos - rPos - 1 - expon) < 0 ? 14 : rVal;
        }
        if (rPos != -1) {
            return 14;
        }
        return 14;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int unpack(DomainEnvironment env, String format, Object[] objs) {
        int arrLen = 0;
        boolean arrSize = false;
        int strIndex = 0;
        int fmtIndex = 0;
        int width = 0;
        int precision = 0;
        int argCount = 0;
        int state = 0;
        int delim = 0;
        int defWidth = 0;
        int strLen = this.count;
        int arrIndex = 0;
        boolean float_precision = false;
        Object obj = null;
        if (this.unpackTempString == null) {
            this.unpackTempString = new DomainString();
        } else {
            this.unpackTempString.reset();
        }
        int tempLen = 0;
        boolean first = true;
        boolean isArray = false;
        String defDate = null;
        String curDate = null;
        String defTime = null;
        String curTime = null;
        char[] strValue = new char[this.count];
        System.arraycopy(this.value, 0, strValue, 0, this.count);
        int strValueLen = this.count;
        char[] ch = format.toCharArray();
        int lastError = 0;
        env.LastError.reset();
        PackToken packToken = new PackToken();
        block50: while (strIndex < strLen) {
            int end;
            int begin;
            fmtIndex = packToken.GetPackToken(ch, fmtIndex);
            if ((packToken.flag & 0x10) != 0) {
                if ((width = ((DomainInteger)objs[argCount++]).getValue()) > 0) {
                    packToken.width = width;
                } else {
                    lastError = 7;
                }
            }
            if ((packToken.flag & 0x20) != 0) {
                if ((precision = ((DomainInteger)objs[argCount++]).getValue()) > 0) {
                    packToken.precision = precision;
                } else {
                    lastError = 7;
                }
            }
            switch (packToken.token) {
                case '!': {
                    break block50;
                }
                case 'a': {
                    arrLen = packToken.width;
                    arrIndex = 0;
                    isArray = true;
                    continue block50;
                }
                case '?': {
                    continue block50;
                }
                case 'p': {
                    state = 1;
                    delim = packToken.width;
                    continue block50;
                }
                case 'j': {
                    switch (state) {
                        case 0: {
                            strIndex += packToken.width;
                            break;
                        }
                        case 1: {
                            begin = -1;
                            end = -1;
                            if (strIndex < strLen && strValue[strIndex] == delim && !first) {
                                ++strIndex;
                            }
                            block51: while (strIndex < strLen && strValue[strIndex] != delim) {
                                switch (strValue[strIndex]) {
                                    case '\"': {
                                        begin = ++strIndex;
                                        while (strIndex < strLen) {
                                            if (strValue[strIndex] == '\\' && strIndex + 1 < strLen && strValue[strIndex + 1] == '\"') {
                                                ++strIndex;
                                            } else if (strValue[strIndex] == '\"' && strIndex + 1 < strLen && strValue[strIndex + 1] == '\"') {
                                                ++strIndex;
                                            } else if (strValue[strIndex] == '\"') break;
                                            ++strIndex;
                                        }
                                        end = strIndex;
                                        while (strIndex < strLen && strValue[strIndex] != delim) {
                                            ++strIndex;
                                        }
                                        continue block51;
                                    }
                                    case ' ': {
                                        ++strIndex;
                                        continue block51;
                                    }
                                }
                                if (begin == -1) {
                                    begin = strIndex;
                                }
                                end = ++strIndex;
                            }
                            first = false;
                            continue block50;
                        }
                    }
                    continue block50;
                }
                case 'w': {
                    state = 0;
                    defWidth = packToken.width;
                    continue block50;
                }
                case 'd': {
                    if ((defDate == null || defDate.equals("")) && packToken.prefix.equals("")) {
                        defDate = env.getDateInFormat();
                    }
                    curDate = !packToken.prefix.equals("") ? packToken.prefix : defDate;
                    break;
                }
                case 't': {
                    if (defTime.equals("") && packToken.prefix.equals("")) {
                        defTime = env.getTimeInFormat();
                    }
                    curTime = !packToken.prefix.equals("") ? packToken.prefix : defTime;
                    break;
                }
                case 'e': {
                    defDate = !packToken.prefix.equals("") ? packToken.prefix : env.getDateOutFormat();
                    continue block50;
                }
                case 'u': {
                    defTime = !packToken.prefix.equals("") ? packToken.prefix : env.getTimeOutFormat();
                    continue block50;
                }
            }
            block54: do {
                if (arrLen > 0 && isArray) {
                    obj = ((Object[])objs[argCount])[arrIndex++];
                    if (--arrLen == 0) {
                        ++argCount;
                        isArray = false;
                    }
                } else {
                    if (isArray) {
                        ++argCount;
                        isArray = false;
                        continue;
                    }
                    obj = objs[argCount];
                    ++argCount;
                }
                if ((packToken.flag & 8) == 8 && packToken.token == 's') {
                    if (state == 1 && strValue[strIndex] == delim && !first) {
                        ++strIndex;
                    }
                    state = 2;
                }
                switch (state) {
                    case 0: {
                        width = packToken.width == 0 ? defWidth : packToken.width;
                        width = Math.min(width, strLen - strIndex);
                        this.unpackTempString.setValue(this.substring(strIndex, width));
                        if ((packToken.flag & 2) == 0) {
                            this.unpackTempString.trim();
                        }
                        tempLen = width;
                        strIndex += width;
                        break;
                    }
                    case 1: {
                        begin = -1;
                        end = -1;
                        if (strIndex < strLen && strValue[strIndex] == delim && !first) {
                            ++strIndex;
                        }
                        boolean isDone = false;
                        boolean inQuote = false;
                        block55: while (strIndex < strLen && !isDone) {
                            if (strValue[strIndex] == delim && !inQuote) {
                                isDone = true;
                                break;
                            }
                            switch (strValue[strIndex]) {
                                case '\"': {
                                    ++strIndex;
                                    if (!inQuote) {
                                        if (begin == -1) {
                                            begin = strIndex;
                                            inQuote = true;
                                            continue block55;
                                        }
                                        end = strIndex;
                                        continue block55;
                                    }
                                    if (strIndex < strLen && strValue[strIndex] == '\"') {
                                        ++strIndex;
                                        continue block55;
                                    }
                                    end = strIndex - 1;
                                    while (strIndex < strLen && strValue[strIndex] != delim) {
                                        ++strIndex;
                                    }
                                    isDone = true;
                                    continue block55;
                                }
                                case '\\': {
                                    if (begin == -1) {
                                        begin = strIndex;
                                    }
                                    if (strValue[++strIndex] != '\"') continue block55;
                                    ++strIndex;
                                    continue block55;
                                }
                                case ' ': {
                                    if ((packToken.flag & 2) != 0) break;
                                    ++strIndex;
                                    continue block55;
                                }
                            }
                            if (begin == -1) {
                                begin = strIndex;
                            }
                            end = ++strIndex;
                        }
                        if (begin != -1 && end != begin) {
                            this.unpackTempString.setValue(strValue, begin, end - begin);
                            if (inQuote) {
                                this.unpackTempString.replace("\"\"", "\"", 0, 0);
                            }
                            this.unpackTempString.replace("\\\"", "\"", 0, 0);
                            tempLen = end - begin;
                        } else if (tempLen > 0) {
                            this.unpackTempString.reset();
                            tempLen = 0;
                        }
                        width = 0;
                        break;
                    }
                    case 2: {
                        this.unpackTempString.setValue(strValue, strIndex, strValueLen - strIndex);
                        tempLen = this.unpackTempString.length();
                        strIndex += tempLen;
                        break;
                    }
                }
                first = false;
                switch (packToken.token) {
                    case 'c': {
                        if (packToken.prefix == null || tempLen <= 0) break;
                        this.unpackTempString.insert(0, packToken.prefix);
                        tempLen += packToken.plen;
                        break;
                    }
                    case 'f': 
                    case 'm': {
                        if ((packToken.flag & 0x40) != 64 || packToken.precision <= 0) break;
                        this.unpackTempString.insert(packToken.precision, ".");
                        break;
                    }
                }
                switch (packToken.token) {
                    case '!': {
                        lastError = 4;
                        break;
                    }
                    case 'm': {
                        try {
                            ((DomainCurrency)obj).setValue(env, this.unpackTempString);
                            if (!env.LastError.isTrue()) continue block54;
                            lastError = env.LastError.getValue();
                        }
                        catch (NumberFormatException ex) {
                            ((DomainInteger)obj).setValue(0);
                            lastError = 1;
                        }
                        break;
                    }
                    case 'f': {
                        try {
                            ((DomainFloat)obj).setValue(env, this.unpackTempString);
                            if (!env.LastError.isTrue()) continue block54;
                            lastError = env.LastError.getValue();
                        }
                        catch (NumberFormatException ex) {
                            ((DomainInteger)obj).setValue(0);
                            lastError = 1;
                        }
                        break;
                    }
                    case 'i': {
                        try {
                            ((DomainInteger)obj).setValue(env, this.unpackTempString);
                            if (!env.LastError.isTrue()) continue block54;
                            lastError = env.LastError.getValue();
                        }
                        catch (NumberFormatException ex) {
                            ((DomainInteger)obj).setValue(0);
                            lastError = 1;
                        }
                        break;
                    }
                    case 's': {
                        if (obj instanceof DomainString) {
                            ((DomainString)obj).setValue(this.unpackTempString);
                            break;
                        }
                        if (!(obj instanceof DomainFixedString)) continue block54;
                        ((DomainFixedString)obj).setValue(this.unpackTempString);
                        break;
                    }
                    case 'c': {
                        ((DomainCode)obj).setValue(env.getCurrentList().append(this.unpackTempString));
                        break;
                    }
                    case 'd': {
                        if (obj instanceof DomainExtDate) {
                            ((DomainExtDate)obj).setValue(DomainString.toExtDate(env, curDate, this.unpackTempString, null));
                        } else {
                            ((DomainDate)obj).setValue(DomainString.toDate(env, curDate, this.unpackTempString, null));
                        }
                        if (!env.LastError.isTrue()) continue block54;
                        lastError = env.LastError.getValue();
                        break;
                    }
                    case 't': {
                        if (obj instanceof DomainExtDate) {
                            ((DomainExtDate)obj).setValue(DomainString.toExtDate(env, curTime, this.unpackTempString, null));
                        } else {
                            ((DomainDate)obj).setValue(DomainString.toDate(env, curTime, this.unpackTempString, null));
                        }
                        if (!env.LastError.isTrue()) continue block54;
                        lastError = env.LastError.getValue();
                        break;
                    }
                }
            } while (arrLen > 0 && strIndex < strLen);
        }
        if (lastError != 0) {
            env.LastError.setValue(lastError);
        }
        if (arrLen > 0) {
            ++argCount;
        }
        return objs.length - argCount;
    }

    @Override
    public DomainVariable copy() {
        return new DomainString(this);
    }

    @Override
    public boolean isTrue() {
        return this.count != 0;
    }

    public static DomainDate toDate(DomainEnvironment env, String format, DomainString s, DomainInteger position) {
        return DomainString.toDate(env, format, s.toCharArray(), position);
    }

    public static DomainExtDate toExtDate(DomainEnvironment env, String format, DomainString s, DomainInteger position) {
        return DomainString.toExtDate(env, format, s.toCharArray(), position);
    }

    public static DomainDate toDate(DomainEnvironment env, String format, String s, DomainInteger position) {
        return DomainString.toDate(env, format, s.toCharArray(), position);
    }

    public static DomainExtDate toExtDate(DomainEnvironment env, String format, String s, DomainInteger position) {
        return DomainString.toExtDate(env, format, s.toCharArray(), position);
    }

    private static DomainDate toDate(DomainEnvironment env, String format, char[] buffer, DomainInteger position) {
        boolean optional = false;
        boolean found = false;
        boolean fmtIndex = false;
        boolean strIndex = false;
        boolean state = false;
        boolean width = false;
        DomainDate result = new DomainDate();
        int strLen = buffer.length;
        env.LastError.reset();
        if (strLen == 0) {
            env.LastError.setValue(4);
            return result;
        }
        if (!DomainDate.parseDate(format, buffer, result, position)) {
            env.LastError.setValue(3);
            return result;
        }
        env.LastError.setValue(0);
        return result;
    }

    private static DomainExtDate toExtDate(DomainEnvironment env, String format, char[] buffer, DomainInteger position) {
        DomainExtDate result = new DomainExtDate();
        int strLen = buffer.length;
        env.LastError.reset();
        if (strLen == 0) {
            env.LastError.setValue(4);
            return result;
        }
        if (!DomainExtDate.parseDate(format, buffer, result, position)) {
            env.LastError.setValue(3);
            return result;
        }
        env.LastError.setValue(0);
        return result;
    }

    public void crypt() {
        int current_index = 0;
        while (current_index != this.count) {
            int position = ENCRYPT.indexOf(this.value[current_index]);
            if (position == -1) continue;
            position = position - ENCRYPT_WRAP > 0 ? (position -= ENCRYPT_WRAP) : (position += ENCRYPT_WRAP);
            this.value[current_index] = ENCRYPT.charAt(position);
            ++current_index;
        }
    }

    public static int strSwitch(String str, byte[] a) {
        int[] result = new int[1];
        boolean[] branch = new boolean[1];
        if (DomainEcUtil.ecIndex(str.getBytes(), a, 0, result, null, branch) != 0) {
            return 0;
        }
        return result[0];
    }

    public String split(String fmt) {
        DomainString str = this.modify(fmt);
        this.delete(0, str.length());
        return str.toString();
    }

    @Override
    public DomainVariable getNewInstance(DomainVariable[] a, int i2) {
        return new DomainString((DomainString[])a, i2);
    }

    private static DomainString valueOf(double d) {
        return new DomainString(new DomainFloat(d).toString());
    }

    public static String valueOfAsString(double d) {
        return new DomainFloat(d).toString();
    }

    public static DomainString strPad(DomainEnvironment env, DomainString source, int length, DomainString pad) {
        DomainString dest = new DomainString();
        env.LastError.setValue(0);
        if (length < 0) {
            length = 0;
            env.LastError.setValue(7);
        }
        if (pad.equals("")) {
            env.LastError.setValue(4);
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (i2 < source.length()) {
                dest.append(source.charAt(i2));
                continue;
            }
            if (pad.equals("")) continue;
            dest.append(pad.charAt(0));
        }
        return dest;
    }

    public DomainString strOverlay(DomainEnvironment env, int pos, DomainString src) {
        DomainString rslt = new DomainString();
        if (pos < 0 || src.count + pos > this.count) {
            rslt.reset();
        } else {
            rslt.setValue(this);
            rslt.replace(pos, pos + src.count, src);
        }
        this.setValue(rslt);
        return rslt;
    }

    public static int strCount(String source, String pattern, int start) {
        int count = 0;
        int position = start;
        if (pattern.compareTo("") == 0 || start < 0 || start + pattern.length() > source.length()) {
            return 0;
        }
        while ((position = source.indexOf(pattern, position)) != -1) {
            ++count;
            position += pattern.length();
        }
        return count;
    }

    public static int strCount(String source, String pattern, DomainInteger start) {
        return DomainString.strCount(source, pattern, start.value);
    }

    public static int strCount(String source, DomainString pattern, int start) {
        return DomainString.strCount(source, new String(pattern.value, 0, pattern.count), start);
    }

    public static int strCount(String source, DomainString pattern, DomainInteger start) {
        return DomainString.strCount(source, new String(pattern.value, 0, pattern.count), start.value);
    }

    public static int strCount(DomainString source, String pattern, int start) {
        return DomainString.strCount(new String(source.value, 0, source.count), pattern, start);
    }

    public static int strCount(DomainString source, String pattern, DomainInteger start) {
        return DomainString.strCount(new String(source.value, 0, source.count), pattern, start.value);
    }

    public static int strCount(DomainString source, DomainString pattern, int start) {
        return DomainString.strCount(new String(source.value, 0, source.count), new String(pattern.value, 0, pattern.count), start);
    }

    public static int strCount(DomainString source, DomainString pattern, DomainInteger start) {
        return DomainString.strCount(new String(source.value, 0, source.count), new String(pattern.value, 0, pattern.count), start.value);
    }

    public static int toBitMemberValue(DomainEnvironment _env, String value) {
        int return_value;
        _env.LastError.reset();
        if (value.length() == 0) {
            _env.LastError.setValue(4);
            return 0;
        }
        if (value.charAt(0) == '1') {
            return_value = 1;
        } else if (value.charAt(0) == '0') {
            return_value = 0;
        } else {
            _env.LastError.setValue(1);
            return 0;
        }
        if (value.length() > 1) {
            _env.LastError.setValue(6);
        }
        return return_value;
    }

    public static int toBitMemberValue(DomainEnvironment _env, DomainString value) {
        return DomainString.toBitMemberValue(_env, value.toString());
    }

    public DomainString strPartial(int start, int length) {
        if (start < 0 || start > this.count || start + length > this.count || length < 0 || length > this.count) {
            return new DomainString("");
        }
        if (length == 0) {
            length = this.count - start;
        }
        return this.substring(start, length);
    }

    public DomainString strPartial(DomainInteger start, int length) {
        return this.strPartial(start.getValue(), length);
    }

    public DomainString strPartial(int start, DomainInteger length) {
        return this.strPartial(start, length.getValue());
    }

    public DomainString strPartial(DomainInteger start, DomainInteger length) {
        return this.strPartial(start.getValue(), length.getValue());
    }

    public static DomainString strPartial(String s, int start, int length) {
        return new DomainString(s).strPartial(start, length);
    }

    public static int strSearchExt(DomainString src, DomainString pattern, int offset, int count, int flag, DomainInteger pos) {
        char[] sbuf = (flag & 1) != 0 ? DomainString.toLowerCaseC((DomainString)src).value : src.value;
        char[] pbuf = (flag & 1) != 0 ? DomainString.toLowerCaseC((DomainString)pattern).value : pattern.value;
        int BytesToSearch = src.length();
        int PatternLength = pattern.length();
        if (flag < 0 || flag > 3) {
            return 0;
        }
        if (offset < 0) {
            return 0;
        }
        if (BytesToSearch < offset) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if ((flag & 2) == 0) {
            int begsearch = offset;
            int endsearch = BytesToSearch;
            int sptr = begsearch;
            int pptr = 0;
            pos.setValue(sptr);
            while (sptr >= begsearch && sptr < endsearch) {
                boolean match = sbuf[sptr] == pbuf[pptr];
                pptr = match ? pptr + 1 : 0;
                ++sptr;
                if (!match) {
                    pos.setValue(sptr);
                }
                if (pptr != PatternLength) continue;
                if (--count == 0) {
                    return 1;
                }
                pptr = 0;
                pos.setValue(sptr);
            }
        } else {
            int endsearch;
            int BytesToCompare = PatternLength - 1;
            int begsearch = 0;
            int pptr = BytesToCompare;
            for (int sptr = endsearch = BytesToSearch - offset - 1; sptr >= begsearch && sptr <= endsearch; --sptr) {
                boolean match = sbuf[sptr] == pbuf[pptr];
                int n = pptr = match ? pptr - 1 : BytesToCompare;
                if (pptr >= 0) continue;
                if (--count == 0) {
                    pos.setValue(sptr);
                    return 1;
                }
                pptr = BytesToCompare;
            }
        }
        pos.setValue(0);
        return 0;
    }

    private boolean startsWith(char[] buffer, int length, int toffset) {
        char[] ta = this.value;
        int to = toffset;
        char[] pa = buffer;
        int po = 0;
        int pc = length;
        if (toffset < 0 || toffset > this.count - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public int strStartsWith(String prefix) {
        return this.startsWith(prefix.toCharArray(), prefix.length(), 0) ? 1 : 0;
    }

    public int strStartsWith(DomainString prefix) {
        return this.startsWith(prefix.value, prefix.count, 0) ? 1 : 0;
    }

    public int strStartsWith(DomainFixedString prefix) {
        return this.startsWith(prefix.value, prefix.length(), 0) ? 1 : 0;
    }

    public static int strStartsWith(String source, String prefix) {
        return source.startsWith(prefix) ? 1 : 0;
    }

    public static int strStartsWith(String source, DomainString prefix) {
        return source.startsWith(prefix.toString()) ? 1 : 0;
    }

    public int strEndsWith(String suffix) {
        return this.startsWith(suffix.toCharArray(), suffix.length(), this.count - suffix.length()) ? 1 : 0;
    }

    public int strEndsWith(DomainString suffix) {
        return this.startsWith(suffix.value, suffix.count, this.count - suffix.count) ? 1 : 0;
    }

    public int strEndsWith(DomainFixedString suffix) {
        return this.startsWith(suffix.value, suffix.length(), this.count - suffix.length()) ? 1 : 0;
    }

    public static int strEndsWith(String source, String suffix) {
        return source.endsWith(suffix) ? 1 : 0;
    }

    public static int strEndsWith(String source, DomainString suffix) {
        return source.endsWith(suffix.toString()) ? 1 : 0;
    }

    protected static class PackToken {
        String prefix;
        int plen;
        int width;
        int precision;
        char token;
        int flag;

        PackToken() {
        }

        public int GetPackToken(char[] fmt, int fmtIndex) {
            if ('\u0003' == fmt[0]) {
                return this.GetPackBinaryToken(fmt, fmtIndex);
            }
            this.prefix = "";
            this.plen = 0;
            this.width = 0;
            this.flag = 0;
            this.precision = 0;
            this.token = fmtIndex < fmt.length ? fmt[fmtIndex++] : (char)33;
            switch (this.token) {
                default: {
                    break;
                }
                case 'p': {
                    this.width = fmt[fmtIndex++];
                    break;
                }
                case 'a': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'i': 
                case 'j': 
                case 'm': 
                case 's': 
                case 't': 
                case 'u': 
                case 'w': {
                    boolean done = false;
                    while (fmtIndex < fmt.length && !done) {
                        switch (fmt[fmtIndex]) {
                            case '0': {
                                this.flag |= 1;
                                break;
                            }
                            case '+': {
                                this.flag |= 8;
                                break;
                            }
                            case ' ': {
                                this.flag |= 2;
                                break;
                            }
                            case '-': {
                                this.flag |= 4;
                                break;
                            }
                            case '*': {
                                this.flag |= 0x10;
                                break;
                            }
                            default: {
                                done = true;
                            }
                        }
                        if (done) continue;
                        ++fmtIndex;
                    }
                    int begin = fmtIndex;
                    while (fmtIndex < fmt.length && Character.isDigit(fmt[fmtIndex]) && (fmt[fmtIndex] & 0x10) != 0) {
                        this.width = this.width * 10 + fmt[fmtIndex] - 48;
                        ++fmtIndex;
                    }
                    if (fmtIndex < fmt.length && fmt[fmtIndex] == '<') {
                        begin = ++fmtIndex;
                        while (fmtIndex < fmt.length && fmt[fmtIndex] != '>') {
                            ++fmtIndex;
                        }
                        if (fmtIndex > begin) {
                            this.plen = fmtIndex - begin;
                            this.prefix = String.valueOf(fmt, begin, this.plen);
                        } else {
                            this.token = (char)63;
                        }
                        ++fmtIndex;
                    }
                    if (fmtIndex >= fmt.length || fmt[fmtIndex] != '.') break;
                    if (fmt[++fmtIndex] == '*') {
                        ++fmtIndex;
                        this.flag |= 0x20;
                        break;
                    }
                    while (fmtIndex < fmt.length && Character.isDigit(fmt[fmtIndex])) {
                        this.precision = this.precision * 10 + fmt[fmtIndex] - 48;
                        ++fmtIndex;
                    }
                    break block0;
                }
            }
            return fmtIndex;
        }

        private int GetNumber(char[] fmt, int[] index) {
            int n = index[0];
            index[0] = n + 1;
            int val = fmt[n];
            if ((val & 0x80) != 0) {
                boolean sign = (val & 0x40) != 0;
                int count = (val & 0x38) >> 3;
                val &= 7;
                while (count > 0) {
                    val <<= 8;
                    int n2 = index[0];
                    index[0] = n2 + 1;
                    val += fmt[n2];
                    --count;
                }
                val = sign ? -val : val;
            }
            return val;
        }

        public int GetPackBinaryToken(char[] fmt, int fmtIndex) {
            int[] index = new int[]{fmtIndex};
            this.prefix = "";
            this.plen = 0;
            this.flag = 0;
            this.width = 0;
            this.precision = 0;
            if (index[0] == 0) {
                index[0] = index[0] + 1;
            }
            if (index[0] < fmt.length) {
                int n = index[0];
                index[0] = n + 1;
                this.token = PACK_TEXT[fmt[n]];
            } else {
                this.token = (char)33;
            }
            switch (this.token) {
                case '!': 
                case '?': {
                    break;
                }
                case 'p': {
                    int n = index[0];
                    index[0] = n + 1;
                    this.width = fmt[n];
                    break;
                }
                default: {
                    int n = index[0];
                    index[0] = n + 1;
                    char tokenFlag = fmt[n];
                    if ((tokenFlag & '\u0001') != 0) {
                        this.flag = this.GetNumber(fmt, index);
                    }
                    if ((tokenFlag & 2) != 0) {
                        this.width = this.GetNumber(fmt, index);
                    }
                    if ((tokenFlag & 4) != 0) {
                        this.precision = this.GetNumber(fmt, index);
                    }
                    if ((tokenFlag & 8) == 0) break;
                    for (int i2 = index[0]; fmt[i2] != '\u0000' && i2 < fmt.length; ++i2) {
                        ++this.plen;
                    }
                    this.prefix = new String(fmt, index[0], this.plen);
                    index[0] = index[0] + (this.plen + 1);
                }
            }
            return index[0];
        }
    }
}

